/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

import com.foilen.smalltools.tools.ThreadTools;
import java.util.concurrent.atomic.AtomicBoolean;

public class DelayedEvent
extends Thread {
    private long delayInMilliseconds;
    private Runnable event;
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public DelayedEvent(long delayInMilliseconds, Runnable event) {
        this.delayInMilliseconds = delayInMilliseconds;
        this.event = event;
        this.start();
    }

    public void cancel() {
        this.canceled.set(true);
    }

    @Override
    public void run() {
        long endTime = System.currentTimeMillis() + this.delayInMilliseconds;
        long delta = endTime - System.currentTimeMillis();
        while (!this.canceled.get() && delta > 0L) {
            long wait = Math.min(1000L, delta);
            ThreadTools.sleep(wait);
            delta = endTime - System.currentTimeMillis();
        }
        if (!this.canceled.get()) {
            this.event.run();
        }
    }
}

