/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarkLaunchingDisabledFeatures {
    private static final Logger logger = LoggerFactory.getLogger(DarkLaunchingDisabledFeatures.class);
    private List<String> disabledFeatures = new ArrayList<String>();

    public boolean isAllFeaturesDisabled(String ... featureNames) {
        if (featureNames == null || featureNames.length == 0) {
            return false;
        }
        for (String featureName : featureNames) {
            if (this.disabledFeatures.contains(featureName)) continue;
            logger.debug("The feature {} is enabled", (Object)featureName);
            return false;
        }
        return true;
    }

    public boolean isAllFeaturesEnabled(String ... featureNames) {
        if (featureNames == null || featureNames.length == 0) {
            return true;
        }
        for (String featureName : featureNames) {
            if (!this.disabledFeatures.contains(featureName)) continue;
            logger.debug("The feature {} is disabled", (Object)featureName);
            return false;
        }
        return true;
    }

    public boolean isAnyFeaturesDisabled(String ... featureNames) {
        if (featureNames == null || featureNames.length == 0) {
            return false;
        }
        for (String featureName : featureNames) {
            if (!this.disabledFeatures.contains(featureName)) continue;
            logger.debug("The feature {} is disabled", (Object)featureName);
            return true;
        }
        return false;
    }

    public boolean isAnyFeaturesEnabled(String ... featureNames) {
        if (featureNames == null || featureNames.length == 0) {
            return true;
        }
        for (String featureName : featureNames) {
            if (this.disabledFeatures.contains(featureName)) continue;
            logger.debug("The feature {} is enabled", (Object)featureName);
            return true;
        }
        return false;
    }

    public void setDisabledFeatures(List<String> disabledFeatures) {
        this.disabledFeatures = disabledFeatures;
    }

    public void setDisabledFeatures(String disabledFeatures) {
        if (disabledFeatures == null || disabledFeatures.isEmpty()) {
            this.disabledFeatures = new ArrayList<String>();
        }
        String[] disabledFeaturesArray = disabledFeatures.split(",");
        for (int i = 0; i < disabledFeaturesArray.length; ++i) {
            disabledFeaturesArray[i] = disabledFeaturesArray[i].trim();
        }
        this.setDisabledFeatures(disabledFeaturesArray);
    }

    public void setDisabledFeatures(String ... disabledFeatures) {
        this.disabledFeatures = Arrays.asList(disabledFeatures);
    }
}

