/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class CacheObject<T> {
    private final Duration duration;
    private final Supplier<T> supplier;
    private AtomicReference<T> objectWrapper;
    private long expireAt;

    public CacheObject(Duration duration, Supplier<T> supplier) {
        this.duration = duration;
        this.supplier = supplier;
    }

    public synchronized T get() {
        if (this.objectWrapper == null || System.currentTimeMillis() > this.expireAt) {
            if (this.objectWrapper == null) {
                this.objectWrapper = new AtomicReference();
            }
            this.objectWrapper.set(this.supplier.get());
            this.expireAt = System.currentTimeMillis() + this.duration.toMillis();
        }
        return this.objectWrapper.get();
    }
}

