/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget.internal;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flyco.dialog.listener.OnBtnClickL;
import com.flyco.dialog.widget.base.BaseDialog;

public abstract class BaseAlertDialog<T extends BaseAlertDialog<T>>
extends BaseDialog<T> {
    protected LinearLayout mLlContainer;
    protected TextView mTvTitle;
    protected String mTitle;
    protected int mTitleTextColor;
    protected float mTitleTextSize;
    protected boolean mIsTitleShow = true;
    protected TextView mTvContent;
    protected String mContent;
    protected int mContentGravity = 16;
    protected int mContentTextColor;
    protected float mContentTextSize;
    protected int mBtnNum = 2;
    protected LinearLayout mLlBtns;
    protected TextView mTvBtnLeft;
    protected TextView mTvBtnRight;
    protected TextView mTvBtnMiddle;
    protected String mBtnLeftText = "\u53d6\u6d88";
    protected String mBtnRightText = "\u786e\u5b9a";
    protected String mBtnMiddleText = "\u7ee7\u7eed";
    protected int mLeftBtnTextColor;
    protected int mRightBtnTextColor;
    protected int mMiddleBtnTextColor;
    protected float mLeftBtnTextSize = 15.0f;
    protected float mRightBtnTextSize = 15.0f;
    protected float mMiddleBtnTextSize = 15.0f;
    protected int mBtnPressColor = Color.parseColor((String)"#E3E3E3");
    protected OnBtnClickL mOnBtnLeftClickL;
    protected OnBtnClickL mOnBtnRightClickL;
    protected OnBtnClickL mOnBtnMiddleClickL;
    protected float mCornerRadius = 3.0f;
    protected int mBgColor = Color.parseColor((String)"#ffffff");

    public BaseAlertDialog(Context context) {
        super(context);
        this.widthScale(0.88f);
        this.mLlContainer = new LinearLayout(context);
        this.mLlContainer.setOrientation(1);
        this.mTvTitle = new TextView(context);
        this.mTvContent = new TextView(context);
        this.mLlBtns = new LinearLayout(context);
        this.mLlBtns.setOrientation(0);
        this.mTvBtnLeft = new TextView(context);
        this.mTvBtnLeft.setGravity(17);
        this.mTvBtnMiddle = new TextView(context);
        this.mTvBtnMiddle.setGravity(17);
        this.mTvBtnRight = new TextView(context);
        this.mTvBtnRight.setGravity(17);
    }

    @Override
    public void setUiBeforShow() {
        this.mTvTitle.setVisibility(this.mIsTitleShow ? 0 : 8);
        this.mTvTitle.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mTitle) ? "\u6e29\u99a8\u63d0\u793a" : this.mTitle));
        this.mTvTitle.setTextColor(this.mTitleTextColor);
        this.mTvTitle.setTextSize(2, this.mTitleTextSize);
        this.mTvContent.setGravity(this.mContentGravity);
        this.mTvContent.setText((CharSequence)this.mContent);
        this.mTvContent.setTextColor(this.mContentTextColor);
        this.mTvContent.setTextSize(2, this.mContentTextSize);
        this.mTvContent.setLineSpacing(0.0f, 1.3f);
        this.mTvBtnLeft.setText((CharSequence)this.mBtnLeftText);
        this.mTvBtnRight.setText((CharSequence)this.mBtnRightText);
        this.mTvBtnMiddle.setText((CharSequence)this.mBtnMiddleText);
        this.mTvBtnLeft.setTextColor(this.mLeftBtnTextColor);
        this.mTvBtnRight.setTextColor(this.mRightBtnTextColor);
        this.mTvBtnMiddle.setTextColor(this.mMiddleBtnTextColor);
        this.mTvBtnLeft.setTextSize(2, this.mLeftBtnTextSize);
        this.mTvBtnRight.setTextSize(2, this.mRightBtnTextSize);
        this.mTvBtnMiddle.setTextSize(2, this.mMiddleBtnTextSize);
        if (this.mBtnNum == 1) {
            this.mTvBtnLeft.setVisibility(8);
            this.mTvBtnRight.setVisibility(8);
        } else if (this.mBtnNum == 2) {
            this.mTvBtnMiddle.setVisibility(8);
        }
        this.mTvBtnLeft.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseAlertDialog.this.mOnBtnLeftClickL != null) {
                    BaseAlertDialog.this.mOnBtnLeftClickL.onBtnClick();
                } else {
                    BaseAlertDialog.this.dismiss();
                }
            }
        });
        this.mTvBtnRight.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseAlertDialog.this.mOnBtnRightClickL != null) {
                    BaseAlertDialog.this.mOnBtnRightClickL.onBtnClick();
                } else {
                    BaseAlertDialog.this.dismiss();
                }
            }
        });
        this.mTvBtnMiddle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseAlertDialog.this.mOnBtnMiddleClickL != null) {
                    BaseAlertDialog.this.mOnBtnMiddleClickL.onBtnClick();
                } else {
                    BaseAlertDialog.this.dismiss();
                }
            }
        });
    }

    public T title(String title) {
        this.mTitle = title;
        return (T)((Object)this);
    }

    public T titleTextColor(int titleTextColor) {
        this.mTitleTextColor = titleTextColor;
        return (T)((Object)this);
    }

    public T titleTextSize(float titleTextSize_SP) {
        this.mTitleTextSize = titleTextSize_SP;
        return (T)((Object)this);
    }

    public T isTitleShow(boolean isTitleShow) {
        this.mIsTitleShow = isTitleShow;
        return (T)((Object)this);
    }

    public T content(String content) {
        this.mContent = content;
        return (T)((Object)this);
    }

    public T contentGravity(int contentGravity) {
        this.mContentGravity = contentGravity;
        return (T)((Object)this);
    }

    public T contentTextColor(int contentTextColor) {
        this.mContentTextColor = contentTextColor;
        return (T)((Object)this);
    }

    public T contentTextSize(float contentTextSize_SP) {
        this.mContentTextSize = contentTextSize_SP;
        return (T)((Object)this);
    }

    public T btnNum(int btnNum) {
        if (btnNum < 1 || btnNum > 3) {
            throw new IllegalStateException("btnNum is [1,3]!");
        }
        this.mBtnNum = btnNum;
        return (T)((Object)this);
    }

    public T btnText(String ... btnTexts) {
        if (btnTexts.length < 1 || btnTexts.length > 3) {
            throw new IllegalStateException(" range of param btnTexts length is [1,3]!");
        }
        if (btnTexts.length == 1) {
            this.mBtnMiddleText = btnTexts[0];
        } else if (btnTexts.length == 2) {
            this.mBtnLeftText = btnTexts[0];
            this.mBtnRightText = btnTexts[1];
        } else if (btnTexts.length == 3) {
            this.mBtnLeftText = btnTexts[0];
            this.mBtnRightText = btnTexts[1];
            this.mBtnMiddleText = btnTexts[2];
        }
        return (T)((Object)this);
    }

    public T btnTextColor(int ... btnTextColors) {
        if (btnTextColors.length < 1 || btnTextColors.length > 3) {
            throw new IllegalStateException(" range of param textColors length is [1,3]!");
        }
        if (btnTextColors.length == 1) {
            this.mMiddleBtnTextColor = btnTextColors[0];
        } else if (btnTextColors.length == 2) {
            this.mLeftBtnTextColor = btnTextColors[0];
            this.mRightBtnTextColor = btnTextColors[1];
        } else if (btnTextColors.length == 3) {
            this.mLeftBtnTextColor = btnTextColors[0];
            this.mRightBtnTextColor = btnTextColors[1];
            this.mMiddleBtnTextColor = btnTextColors[2];
        }
        return (T)((Object)this);
    }

    public T btnTextSize(float ... btnTextSizes) {
        if (btnTextSizes.length < 1 || btnTextSizes.length > 3) {
            throw new IllegalStateException(" range of param btnTextSizes length is [1,3]!");
        }
        if (btnTextSizes.length == 1) {
            this.mMiddleBtnTextSize = btnTextSizes[0];
        } else if (btnTextSizes.length == 2) {
            this.mLeftBtnTextSize = btnTextSizes[0];
            this.mRightBtnTextSize = btnTextSizes[1];
        } else if (btnTextSizes.length == 3) {
            this.mLeftBtnTextSize = btnTextSizes[0];
            this.mRightBtnTextSize = btnTextSizes[1];
            this.mMiddleBtnTextSize = btnTextSizes[2];
        }
        return (T)((Object)this);
    }

    public T btnPressColor(int btnPressColor) {
        this.mBtnPressColor = btnPressColor;
        return (T)((Object)this);
    }

    public T cornerRadius(float cornerRadius_DP) {
        this.mCornerRadius = cornerRadius_DP;
        return (T)((Object)this);
    }

    public T bgColor(int bgColor) {
        this.mBgColor = bgColor;
        return (T)((Object)this);
    }

    public void setOnBtnClickL(OnBtnClickL ... onBtnClickLs) {
        if (onBtnClickLs.length < 1 || onBtnClickLs.length > 3) {
            throw new IllegalStateException(" range of param onBtnClickLs length is [1,3]!");
        }
        if (onBtnClickLs.length == 1) {
            this.mOnBtnMiddleClickL = onBtnClickLs[0];
        } else if (onBtnClickLs.length == 2) {
            this.mOnBtnLeftClickL = onBtnClickLs[0];
            this.mOnBtnRightClickL = onBtnClickLs[1];
        } else if (onBtnClickLs.length == 3) {
            this.mOnBtnLeftClickL = onBtnClickLs[0];
            this.mOnBtnRightClickL = onBtnClickLs[1];
            this.mOnBtnMiddleClickL = onBtnClickLs[2];
        }
    }
}

