/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget.base;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.flyco.animation.BaseAnimatorSet;
import com.flyco.dialog.utils.StatusBarUtils;
import com.nineoldandroids.animation.Animator;

public abstract class BaseDialog<T extends BaseDialog<T>>
extends Dialog {
    protected String mTag;
    protected Context mContext;
    protected DisplayMetrics mDisplayMetrics;
    protected boolean mCancel;
    protected float mWidthScale = 1.0f;
    protected float mHeightScale;
    private BaseAnimatorSet mShowAnim;
    private BaseAnimatorSet mDismissAnim;
    protected LinearLayout mLlTop;
    protected LinearLayout mLlControlHeight;
    private boolean mIsShowAnim;
    private boolean mIsDismissAnim;
    protected float mMaxHeight;
    private boolean mIsPopupStyle;
    private boolean mAutoDismiss;
    private long mAutoDismissDelay = 1500L;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public BaseDialog(Context context) {
        super(context);
        this.setDialogTheme();
        this.mContext = context;
        this.mTag = ((Object)((Object)this)).getClass().getSimpleName();
        this.setCanceledOnTouchOutside(true);
        Log.d((String)this.mTag, (String)"constructor");
    }

    public BaseDialog(Context context, boolean isPopupStyle) {
        this(context);
        this.mIsPopupStyle = isPopupStyle;
    }

    private void setDialogTheme() {
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().addFlags(2);
    }

    public abstract View onCreateView();

    public void onViewCreated(View inflate) {
    }

    public abstract void setUiBeforShow();

    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)this.mTag, (String)"onCreate");
        this.mDisplayMetrics = this.mContext.getResources().getDisplayMetrics();
        this.mMaxHeight = this.mDisplayMetrics.heightPixels - StatusBarUtils.getHeight(this.mContext);
        this.mLlTop = new LinearLayout(this.mContext);
        this.mLlTop.setGravity(17);
        this.mLlControlHeight = new LinearLayout(this.mContext);
        this.mLlControlHeight.setOrientation(1);
        View onCreateView = this.onCreateView();
        this.mLlControlHeight.addView(onCreateView);
        this.mLlTop.addView((View)this.mLlControlHeight);
        this.onViewCreated(onCreateView);
        if (this.mIsPopupStyle) {
            this.setContentView((View)this.mLlTop, new ViewGroup.LayoutParams(-2, -2));
        } else {
            this.setContentView((View)this.mLlTop, new ViewGroup.LayoutParams(this.mDisplayMetrics.widthPixels, (int)this.mMaxHeight));
        }
        this.mLlTop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseDialog.this.mCancel) {
                    BaseDialog.this.dismiss();
                }
            }
        });
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)this.mTag, (String)"onAttachedToWindow");
        this.setUiBeforShow();
        int width = this.mWidthScale == 0.0f ? -2 : (int)((float)this.mDisplayMetrics.widthPixels * this.mWidthScale);
        int height = this.mHeightScale == 0.0f ? -2 : (this.mHeightScale == 1.0f ? (int)this.mMaxHeight : (int)(this.mMaxHeight * this.mHeightScale));
        this.mLlControlHeight.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
        if (this.mShowAnim != null) {
            this.mShowAnim.listener(new BaseAnimatorSet.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    BaseDialog.this.mIsShowAnim = true;
                }

                public void onAnimationRepeat(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    BaseDialog.this.mIsShowAnim = false;
                    BaseDialog.this.delayDismiss();
                }

                public void onAnimationCancel(Animator animator) {
                    BaseDialog.this.mIsShowAnim = false;
                }
            }).playOn((View)this.mLlControlHeight);
        } else {
            BaseAnimatorSet.reset((View)this.mLlControlHeight);
            this.delayDismiss();
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        this.mCancel = cancel;
        super.setCanceledOnTouchOutside(cancel);
    }

    public void show() {
        Log.d((String)this.mTag, (String)"show");
        super.show();
    }

    protected void onStart() {
        super.onStart();
        Log.d((String)this.mTag, (String)"onStart");
    }

    protected void onStop() {
        super.onStop();
        Log.d((String)this.mTag, (String)"onStop");
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.d((String)this.mTag, (String)"onDetachedFromWindow");
    }

    public void dismiss() {
        Log.d((String)this.mTag, (String)"dismiss");
        if (this.mDismissAnim != null) {
            this.mDismissAnim.listener(new BaseAnimatorSet.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    BaseDialog.this.mIsDismissAnim = true;
                }

                public void onAnimationRepeat(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    BaseDialog.this.mIsDismissAnim = false;
                    BaseDialog.this.superDismiss();
                }

                public void onAnimationCancel(Animator animator) {
                    BaseDialog.this.mIsDismissAnim = false;
                    BaseDialog.this.superDismiss();
                }
            }).playOn((View)this.mLlControlHeight);
        } else {
            this.superDismiss();
        }
    }

    public void superDismiss() {
        super.dismiss();
    }

    public void show(int animStyle) {
        Window window = this.getWindow();
        window.setWindowAnimations(animStyle);
        this.show();
    }

    public void showAtLocation(int gravity, int x, int y) {
        if (this.mIsPopupStyle) {
            Window window = this.getWindow();
            WindowManager.LayoutParams params = window.getAttributes();
            window.setGravity(gravity);
            params.x = x;
            params.y = y;
        }
        this.show();
    }

    public void showAtLocation(int x, int y) {
        int gravity = 51;
        this.showAtLocation(gravity, x, y);
    }

    public T dimEnabled(boolean isDimEnabled) {
        if (isDimEnabled) {
            this.getWindow().addFlags(2);
        } else {
            this.getWindow().clearFlags(2);
        }
        return (T)((Object)this);
    }

    public T widthScale(float widthScale) {
        this.mWidthScale = widthScale;
        return (T)((Object)this);
    }

    public T heightScale(float heightScale) {
        this.mHeightScale = heightScale;
        return (T)((Object)this);
    }

    public T showAnim(BaseAnimatorSet showAnim) {
        this.mShowAnim = showAnim;
        return (T)((Object)this);
    }

    public T dismissAnim(BaseAnimatorSet dismissAnim) {
        this.mDismissAnim = dismissAnim;
        return (T)((Object)this);
    }

    public T autoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
        return (T)((Object)this);
    }

    public T autoDismissDelay(long autoDismissDelay) {
        this.mAutoDismissDelay = autoDismissDelay;
        return (T)((Object)this);
    }

    private void delayDismiss() {
        if (this.mAutoDismiss && this.mAutoDismissDelay > 0L) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BaseDialog.this.dismiss();
                }
            }, this.mAutoDismissDelay);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mIsDismissAnim || this.mIsShowAnim || this.mAutoDismiss) {
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    public void onBackPressed() {
        if (this.mIsDismissAnim || this.mIsShowAnim || this.mAutoDismiss) {
            return;
        }
        super.onBackPressed();
    }

    protected int dp2px(float dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }
}

