package com.flybits.android.push.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.flybits.android.push.PushManager
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.utils.Utilities
import com.flybits.internal.db.CommonsDatabase
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

/**
 * The [BroadcastReceiver] for implicit [Intent.ACTION_LOCALE_CHANGED] broadcast.
 *
 * This receiver updates Flybits' back-end with user-selected language codes on a device upon broadcast delivery.
 */
class LocaleChangeListener : BroadcastReceiver() {
    override fun onReceive(context: Context?, intent: Intent?) {
        CoroutineScope(Dispatchers.Default).launch {
            if (context != null && intent?.action == "android.intent.action.LOCALE_CHANGED") {
                val isJwt = SharedElementsFactory.get(context).getSavedJWTToken()
                val user = CommonsDatabase.getDatabase(context).userDao().activeUser
                user?.let {
                    if (isJwt.isNotEmpty()) {
                        PushManager.setLanguage(context, Utilities.getDeviceLanguageCodes(context))
                    }
                }
            }
        }
    }
}