package com.flybits.android.push.deserializations

import com.flybits.android.push.db.converters.PushDataConverter
import com.flybits.android.push.models.PushData
import com.flybits.commons.library.deserializations.IDeserializer
import org.json.JSONArray
import org.json.JSONObject

/**
 * The [DeserializePushNotificationV2] class is responsible for deserializing a JSON object that
 * represents a [Push] model in the [PushData] object which is used to stored into the local DB.
 *
 * Once the [FlyAway] class is re-vamped this class can probably be removed as it has one simple
 * function, however as the [FlyAway] class needs to implement a [IDeserializer] then it is not
 * possible to remove this.
 */
internal class DeserializePushNotificationV2() : IDeserializer<PushData>(){

    /**
     * Deserialize [JSONObject] to [PushData]. If the [jsonObject] is null, a null [PushData] is
     * returned.
     *
     * @param jsonObject The [JSONObject] to deserialize.
     * @return The deserialized [PushData] object or null if [jsonObject] is null.
     */
    override fun fromJson(jsonObject: JSONObject?): PushData? {
        if (jsonObject == null){
            return null;
        }
        return PushDataConverter.convertJsonToPushData(jsonObject.toString())
    }

    /**
     * Automatically converts a [PushData] into a basic json string. This method is never used but
     * it needs to be implemented. This method should not be abstract but its too complicated to
     * change it now.
     *
     * @param obj to serialize.
     * @return The json representation of [obj].
     */
    override fun toJson(obj: PushData?): String {
        return "{}"
    }

    /**
     * Deserialize [JSONArray] to [PushData]. If the [jsonObject] is null, a null [PushData] is
     * returned.
     *
     * @param jsonObject The [JSONArray] to deserialize.
     * @return The deserialized [PushData] object or null if [JSONArray] is null.
     */
    override fun fromJson(jsonObject: JSONArray?): PushData? {
        return null;
    }
}