package com.flybits.android.push.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.android.push.models.Push;
import com.flybits.android.push.utils.PushQueryParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;

import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;


public class PushResult extends PagedResult<Push> {

    public PushResult(Context context, PagedResultCallback<Push> callback, ExecutorService service, QueryParameters parameters, Handler handler){
        super(context, parameters, callback, handler, service);
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K k, @NotNull PagedResultCallback<Push> pagedResultCallback) {
        Push.get(getContext(), (PushQueryParameters) k, pagedResultCallback);
    }
}
