/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.worker;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.NotificationManagerCompat;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.flybits.android.push.analytics.NotificationAuthorizationAnalytics;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.logging.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/flybits/android/push/worker/PushWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "push_release"})
public final class PushWorker
extends Worker {
    private static final String TAG_LOGGING = "PushWorker";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ListenableWorker.Result doWork() {
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return Companion.doWork(context);
    }

    public PushWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/flybits/android/push/worker/PushWorker$Companion;", "", "()V", "TAG_LOGGING", "", "doWork", "Landroidx/work/ListenableWorker$Result;", "applicationContext", "Landroid/content/Context;", "push_release"})
    public static final class Companion {
        @NotNull
        public final ListenableWorker.Result doWork(@NotNull Context applicationContext) {
            Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
            Logger.appendTag((String)PushWorker.TAG_LOGGING).i("PushWorker started");
            SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(applicationContext);
            sharedElements.getIsPushNotificationEnabled();
            boolean isPushEnable = false;
            boolean isEnabledOnApp = NotificationManagerCompat.from((Context)applicationContext).areNotificationsEnabled();
            String pushChannelId = sharedElements.getNotificationChannel();
            if (StringsKt.isBlank((CharSequence)pushChannelId)) {
                isPushEnable = isEnabledOnApp;
            } else if (isEnabledOnApp && Build.VERSION.SDK_INT >= 26) {
                Object object = applicationContext.getSystemService("notification");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                NotificationChannel notificationChannel = ((NotificationManager)object).getNotificationChannel(pushChannelId);
                boolean bl = false;
                boolean bl2 = false;
                NotificationChannel it = notificationChannel;
                boolean bl3 = false;
                NotificationChannel notificationChannel2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)notificationChannel2, (String)"it");
                isPushEnable = notificationChannel2.getImportance() != 0;
            }
            if (sharedElements.setIsPushEnabled(isPushEnable)) {
                NotificationAuthorizationAnalytics pushAnalytics = new NotificationAuthorizationAnalytics(applicationContext);
                NotificationAuthorizationAnalytics.trackPushIsEnabled$default(pushAnalytics, isPushEnable, 0L, 2, null);
                Logger.appendTag((String)PushWorker.TAG_LOGGING).i("update the push status");
            }
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"Result.success()");
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

