/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.util.StringUtil;
import android.database.Cursor;
import com.flybits.android.push.db.converters.StringJsonConverter;
import com.flybits.android.push.db.dao.PushDataDAO;
import com.flybits.android.push.models.PushData;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PushDataDAO_Impl
implements PushDataDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPushData;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPushData;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPushData;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public PushDataDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPushData = new EntityInsertionAdapter<PushData>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `pushData`(`id`,`pushRequestId`,`timestamp`,`version`,`metadataID`,`body`,`title`,`message`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PushData value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getPushRequestId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPushRequestId());
                }
                stmt.bindLong(3, value.getTimestamp());
                stmt.bindLong(4, (long)value.getVersion());
                if (value.getPushPayloadTypeId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPushPayloadTypeId());
                }
                String _tmp = StringJsonConverter.convertJsonToString(value.getBody());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getTitle());
                }
                if (value.getMessage() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMessage());
                }
            }
        };
        this.__deletionAdapterOfPushData = new EntityDeletionOrUpdateAdapter<PushData>(__db){

            public String createQuery() {
                return "DELETE FROM `pushData` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PushData value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
            }
        };
        this.__updateAdapterOfPushData = new EntityDeletionOrUpdateAdapter<PushData>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `pushData` SET `id` = ?,`pushRequestId` = ?,`timestamp` = ?,`version` = ?,`metadataID` = ?,`body` = ?,`title` = ?,`message` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PushData value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getPushRequestId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPushRequestId());
                }
                stmt.bindLong(3, value.getTimestamp());
                stmt.bindLong(4, (long)value.getVersion());
                if (value.getPushPayloadTypeId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPushPayloadTypeId());
                }
                String _tmp = StringJsonConverter.convertJsonToString(value.getBody());
                if (_tmp == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp);
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getTitle());
                }
                if (value.getMessage() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMessage());
                }
                if (value.getId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getId());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM pushData";
                return "DELETE FROM pushData";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM pushData WHERE id = ?";
                return "DELETE FROM pushData WHERE id = ?";
            }
        };
    }

    @Override
    public void insert(List<PushData> pushDataList) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPushData.insert(pushDataList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(PushData pushData) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPushData.insert((Object)pushData);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(PushData pushData) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPushData.handle((Object)pushData);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PushData pushData) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPushData.handle((Object)pushData);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String id) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (id == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, id);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PushData> get(int limit, int offset) {
        String _sql = "SELECT * FROM pushData LIMIT ?, ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM pushData LIMIT ?, ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)offset);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfPushRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfPushPayloadTypeId = _cursor.getColumnIndexOrThrow("metadataID");
            int _cursorIndexOfBody = _cursor.getColumnIndexOrThrow("body");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            ArrayList<PushData> _result = new ArrayList<PushData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpPushRequestId = _cursor.getString(_cursorIndexOfPushRequestId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                String _tmpPushPayloadTypeId = _cursor.getString(_cursorIndexOfPushPayloadTypeId);
                String _tmp = _cursor.getString(_cursorIndexOfBody);
                JSONObject _tmpBody = StringJsonConverter.convertStringToJson(_tmp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                PushData _item = new PushData(_tmpId, _tmpPushRequestId, _tmpTimestamp, _tmpVersion, _tmpPushPayloadTypeId, _tmpBody, _tmpTitle, _tmpMessage);
                _result.add(_item);
            }
            ArrayList<PushData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PushData> getByCachedIds(List<String> ids, int limit) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM pushData WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfPushRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfPushPayloadTypeId = _cursor.getColumnIndexOrThrow("metadataID");
            int _cursorIndexOfBody = _cursor.getColumnIndexOrThrow("body");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            ArrayList<PushData> _result = new ArrayList<PushData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpPushRequestId = _cursor.getString(_cursorIndexOfPushRequestId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                String _tmpPushPayloadTypeId = _cursor.getString(_cursorIndexOfPushPayloadTypeId);
                String _tmp = _cursor.getString(_cursorIndexOfBody);
                JSONObject _tmpBody = StringJsonConverter.convertStringToJson(_tmp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                PushData _item_1 = new PushData(_tmpId, _tmpPushRequestId, _tmpTimestamp, _tmpVersion, _tmpPushPayloadTypeId, _tmpBody, _tmpTitle, _tmpMessage);
                _result.add(_item_1);
            }
            ArrayList<PushData> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushData getById(String id) {
        String _sql = "SELECT * FROM pushData WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM pushData WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            PushData _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfPushRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfPushPayloadTypeId = _cursor.getColumnIndexOrThrow("metadataID");
            int _cursorIndexOfBody = _cursor.getColumnIndexOrThrow("body");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpPushRequestId = _cursor.getString(_cursorIndexOfPushRequestId);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                String _tmpPushPayloadTypeId = _cursor.getString(_cursorIndexOfPushPayloadTypeId);
                String _tmp = _cursor.getString(_cursorIndexOfBody);
                JSONObject _tmpBody = StringJsonConverter.convertStringToJson(_tmp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                _result = new PushData(_tmpId, _tmpPushRequestId, _tmpTimestamp, _tmpVersion, _tmpPushPayloadTypeId, _tmpBody, _tmpTitle, _tmpMessage);
            } else {
                _result = null;
            }
            PushData pushData = _result;
            return pushData;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM pushData WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PushData> getRaw(SupportSQLiteQuery query) {
        SupportSQLiteQuery _internalQuery = query;
        try (Cursor _cursor = this.__db.query(_internalQuery);){
            ArrayList<PushData> _result = new ArrayList<PushData>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                PushData _item = this.__entityCursorConverter_comFlybitsAndroidPushModelsPushData(_cursor);
                _result.add(_item);
            }
            ArrayList<PushData> arrayList = _result;
            return arrayList;
        }
    }

    private PushData __entityCursorConverter_comFlybitsAndroidPushModelsPushData(Cursor cursor) {
        JSONObject _tmpBody;
        int _cursorIndexOfId = cursor.getColumnIndex("id");
        int _cursorIndexOfPushRequestId = cursor.getColumnIndex("pushRequestId");
        int _cursorIndexOfTimestamp = cursor.getColumnIndex("timestamp");
        int _cursorIndexOfVersion = cursor.getColumnIndex("version");
        int _cursorIndexOfPushPayloadTypeId = cursor.getColumnIndex("metadataID");
        int _cursorIndexOfBody = cursor.getColumnIndex("body");
        int _cursorIndexOfTitle = cursor.getColumnIndex("title");
        int _cursorIndexOfMessage = cursor.getColumnIndex("message");
        String _tmpId = _cursorIndexOfId == -1 ? null : cursor.getString(_cursorIndexOfId);
        String _tmpPushRequestId = _cursorIndexOfPushRequestId == -1 ? null : cursor.getString(_cursorIndexOfPushRequestId);
        long _tmpTimestamp = _cursorIndexOfTimestamp == -1 ? 0L : cursor.getLong(_cursorIndexOfTimestamp);
        int _tmpVersion = _cursorIndexOfVersion == -1 ? 0 : cursor.getInt(_cursorIndexOfVersion);
        String _tmpPushPayloadTypeId = _cursorIndexOfPushPayloadTypeId == -1 ? null : cursor.getString(_cursorIndexOfPushPayloadTypeId);
        if (_cursorIndexOfBody == -1) {
            _tmpBody = null;
        } else {
            String _tmp = cursor.getString(_cursorIndexOfBody);
            _tmpBody = StringJsonConverter.convertStringToJson(_tmp);
        }
        String _tmpTitle = _cursorIndexOfTitle == -1 ? null : cursor.getString(_cursorIndexOfTitle);
        String _tmpMessage = _cursorIndexOfMessage == -1 ? null : cursor.getString(_cursorIndexOfMessage);
        PushData _entity = new PushData(_tmpId, _tmpPushRequestId, _tmpTimestamp, _tmpVersion, _tmpPushPayloadTypeId, _tmpBody, _tmpTitle, _tmpMessage);
        return _entity;
    }
}

