package com.flybits.android.push.api;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.push.db.PushDatabase;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;

import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.Executors;

/**
 * @deprecated in version 1.19.0, will be removed in version 3.0.0
 */
@Deprecated
public class FlyPushParsing {

    private static final String TIME_STAMP = "timestamp";
    private static final String ENTITY = "entity";
    private static final String CATEGORY = "category";
    private static final String TITLE = "title";
    private static final String ALERT = "alert";
    private static final String PUSH_PAYLOAD_TYPE_ID = "pushPayloadTypeId";
    private static final String ACTION = "action";
    private static final String PUSH_REQUEST_ID = "pushRequestId";
    private static final String VERSION = "version";
    private static final String BODY = "body";

    /**
     * @deprecated in version 1.19.0, will be removed in version 3.0.0
     */
    @Deprecated
    public static Push parsePushNotification(@NonNull final Context context, @NonNull Map bundle) throws FlybitsPushException {
        verifyPushNotificationIsFlybits(bundle);

        Push notification        = buildPushNotification(bundle);
        if (notification != null) {
            Executors.newSingleThreadExecutor().execute(() -> {
                PushDatabase.getDatabase(context).pushDao().insert(notification);
            });
        }
        return notification;
    }

    /**
     * @deprecated in version 1.19.0, will be removed in version 3.0.0
     */
    @Deprecated
    protected static void verifyPushNotificationIsFlybits(Map map) throws FlybitsPushException{

        if (map == null || !map.containsKey(CATEGORY) || !map.containsKey(VERSION) || !map.containsKey(ENTITY)){
            throw new FlybitsPushException("An invalid FCM bundle was provided. Make sure that the FCM Bundle follows the Flybits Push Model.");
        }
    }

    /**
     * @deprecated in version 1.19.0, will be removed in version 3.0.0
     */
    @Deprecated
    protected static Push buildPushNotification(@NonNull Map map){
        long timestamp = -1;
        if (map.containsKey(TIME_STAMP)){
            BigDecimal bd = new BigDecimal(map.get(TIME_STAMP).toString());
            timestamp = bd.longValue();
        }
        long version        = (map.containsKey(VERSION)) ? Long.parseLong(map.get(VERSION).toString()) : -1 ;
        String body         = (map.containsKey(BODY)) ? map.get(BODY).toString() : null;
        String metadataID   = "unknownID";
        String requestId    = "unknownID";


        String alert = ((map.containsKey(ALERT) && map.get(ALERT).toString().length() != 0)) ? map.get(ALERT).toString() : null;
        String title = ((map.containsKey(TITLE) && map.get(TITLE).toString().length() != 0)) ? map.get(TITLE).toString() : null;

        if (body != null){

            try {
                JSONObject customFieldObject = new JSONObject(body);
                if (!customFieldObject.isNull(PUSH_PAYLOAD_TYPE_ID)){
                    metadataID   = customFieldObject.getString(PUSH_PAYLOAD_TYPE_ID);
                }
                if (!customFieldObject.isNull(PUSH_REQUEST_ID)){
                    requestId = customFieldObject.getString(PUSH_REQUEST_ID);
                }

                return new Push(map.get("id").toString(), map.get(ENTITY).toString(), map.get(ACTION).toString(),
                        map.get(CATEGORY).toString(), requestId, version, timestamp, title, alert, body, metadataID);
            }catch (JSONException ex){}
        }

        return  null;
    }
}
