/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.services;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import com.flybits.android.push.FlyNotification;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.db.converters.PushDataConverter;
import com.flybits.android.push.db.converters.PushDataToPushConverter;
import com.flybits.android.push.models.PushData;
import com.flybits.android.push.models.newPush.DisplayablePush;
import com.flybits.android.push.models.newPush.EventPush;
import com.flybits.android.push.models.newPush.Push;
import com.flybits.android.push.receiver.NotificationClickedReceiver;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/flybits/android/push/services/PushService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "ErrorConvertingPushDataToPush", "", "getNotificationChannelId", "push", "Lcom/flybits/android/push/models/newPush/Push;", "getNotificationIconRes", "", "Lcom/flybits/android/push/models/newPush/DisplayablePush;", "onDisplayableFlybitsPushReceived", "", "onEntityFlybitsPushReceived", "Lcom/flybits/android/push/models/newPush/EventPush;", "onMessageReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "onNonFlybitsPushReceived", "onNotificationClick", "Landroid/app/PendingIntent;", "push_release"})
public abstract class PushService
extends FirebaseMessagingService {
    private final String ErrorConvertingPushDataToPush = "Could Not Parse PushData into Push object. This should not happen. Please contact support@flybits.com for more details";

    public abstract void onNonFlybitsPushReceived(@NotNull RemoteMessage var1);

    public abstract int getNotificationIconRes(@NotNull DisplayablePush var1);

    @NotNull
    public abstract String getNotificationChannelId(@NotNull Push var1);

    public void onMessageReceived(@Nullable RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        RemoteMessage remoteMessage2 = remoteMessage;
        Logger.d((String)("Push received: " + (remoteMessage2 != null ? remoteMessage2.getData() : null)));
        if (remoteMessage != null) {
            try {
                PushData pushData;
                Map map = remoteMessage.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"remoteMessage.data");
                PushData pushData2 = pushData = PushDataConverter.convertMapToPushData(map);
                if (pushData2 != null) {
                    Push push;
                    PushData pushData3 = pushData2;
                    boolean bl = false;
                    boolean bl2 = false;
                    PushData it = pushData3;
                    boolean bl3 = false;
                    Push push2 = push = PushDataToPushConverter.convertPushDataToPush(it);
                    if (push2 != null) {
                        Push push3 = push2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Push itPush = push3;
                        boolean bl6 = false;
                        Push push4 = itPush;
                        if (push4 instanceof DisplayablePush) {
                            this.onDisplayableFlybitsPushReceived((DisplayablePush)itPush);
                        } else if (push4 instanceof EventPush) {
                            this.onEntityFlybitsPushReceived((EventPush)itPush);
                        }
                    } else {
                        Logger.e((String)this.ErrorConvertingPushDataToPush);
                    }
                } else {
                    this.onNonFlybitsPushReceived(remoteMessage);
                }
            }
            catch (FlybitsException e) {
                Logger.exception((String)"ConciergeMessagingService.onMessageReceived()", (Exception)((Exception)((Object)e)));
            }
        }
    }

    public void onNewToken(@Nullable String token) {
        super.onNewToken(token);
        if (token != null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
            CharSequence charSequence = SharedElementsFactory.INSTANCE.get(context).getSavedJWTToken();
            boolean bl = false;
            if (charSequence.length() > 0) {
                Context context2 = this.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"applicationContext");
                PushManager.enablePush(context2, token, new HashMap<String, String>(), null, new Handler(Looper.getMainLooper()));
            }
        }
    }

    @NotNull
    public PendingIntent onNotificationClick(@NotNull DisplayablePush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        Intent intent = new Intent(this.getApplicationContext(), NotificationClickedReceiver.class);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.putExtra("com.flybits.android.push.services.push_notification", (Parcelable)push);
        Intent intent2 = intent;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)push.getId().hashCode(), (Intent)intent2, (int)0x8000000);
        Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_UPDATE_CURRENT)");
        return pendingIntent;
    }

    public void onDisplayableFlybitsPushReceived(@NotNull DisplayablePush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        SharedElements sharedPreferences = SharedElementsFactory.INSTANCE.get(context);
        String pushChannelId = this.getNotificationChannelId(push);
        CharSequence charSequence = pushChannelId;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            sharedPreferences.setNotificationChannel(pushChannelId);
        }
        Context context2 = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"applicationContext");
        new FlyNotification.Builder(context2, push, this.getNotificationChannelId(push), this.getNotificationIconRes(push)).setPendingIntent(this.onNotificationClick(push)).build().show();
    }

    public void onEntityFlybitsPushReceived(@NotNull EventPush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
    }
}

