package com.flybits.android.push.models.pushTypes;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * The {@code WeblinkMetadata} class is responsible for defining all the attributes associated to
 * the {@code Content} Notification Type defined within the Developer Portal and Experience Studio.
 * This Notification Type contains a web link that should be launched once the end-user clicks on
 * the Notification. Once the application is clicked, the notification will launch a webpage in a
 * browser.
 * @deprecated in version 1.19.0, will be removed in version 3.0.0
 */
@Deprecated
public class WeblinkMetadata extends NotificationMetadata {

    private String url;

    /**
     * Default Constructor used to generate this {@code WeblinkMetadata} object.
     *
     * @param json The JSON String that needs to be processed in order to generate values for the
     *             attributes defined in this class.
     */
    public WeblinkMetadata(@NonNull String json) {
        super(json);
    }

    /**
     * Get the identifier that represents a specific piece of {@code Content}.
     *
     * @return The identifier that represents a specific piece of {@code Content}.
     */
    @Nullable
    public String getUrl() {
        return url;
    }

    @Override
    public void fromJSON(String json) {
        try{
            JSONObject jsonObject = new JSONObject(json);
            if (!jsonObject.isNull("url")){
                url = jsonObject.getString("url");
            }
        }catch (JSONException | NullPointerException exception){}
    }

    @Override
    @Nullable
    public PendingIntent onClick(Context context){

        if (url == null){
            return null;
        }

        Intent resultIntent = new Intent(Intent.ACTION_VIEW);

        if (!url.startsWith("https") && !url.startsWith("http")){
            url = "https://" + url;
        }
        resultIntent.setData(Uri.parse(url));
        return PendingIntent.getActivity(context, 0, resultIntent, PendingIntent.FLAG_UPDATE_CURRENT);
    }
}
