package com.flybits.android.push.exceptions;

import com.flybits.commons.library.exceptions.FlybitsException;

/**
 * A class that represents an exception that was thrown by a the Flybits Push SDK when an invalid
 * Bundle was sent to the Push SDK. This can occur when a non-Flybits Push notification is set to
 * the device.
 */
public class FlybitsPushException extends FlybitsException {

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} that includes the current stack trace.
     */
    public FlybitsPushException(){}

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} with the current stack trace and the specified
     * detail message.
     *
     * @param message the detail message for this exception.
     */
    public FlybitsPushException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} with the current stack trace and the specified
     * cause.
     *
     * @param throwable the cause of this exception.
     */
    public FlybitsPushException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public FlybitsPushException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}

