package com.flybits.android.push.analytics

import android.content.Context
import com.flybits.commons.library.analytics.Analytics

/**
 * This Class is to track the analytics data that if the Push Notification is Enabled or Disabled
 * Here is the payload example:
 * {"dataTypeID":"ctx.flybits.pushDeviceAnalytics","value":{"inUse":false},"timestamp":1587747832}
 */
class NotificationAuthorizationAnalytics(context: Context) : Analytics(context) {
    companion object {
        const val PushAuthorizationAnalytics_ACTION = "optIn"
        const val analyticsScope = "pushDeviceAnalytics"
    }

    private fun track( isEnabled: Boolean, timestamp: Long){
        super.track(AnalyticsEvent(analyticsScope, PushAuthorizationAnalytics_ACTION,isEnabled, timestamp))
    }

    fun trackPushIsEnabled(isPushEnabled: Boolean, timestamp: Long = System.currentTimeMillis()) {
        track(isPushEnabled,timestamp)
    }
}