package com.flybits.android.push.services

import android.os.Handler
import android.os.Looper
import com.flybits.android.push.PushManager
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.logging.Logger
import com.google.firebase.messaging.FirebaseMessagingService
import java.util.*

private const val TAG = "FlybitsFirebaseTokenService"

/**
 * Service responsible for sending the firebase device push token to the Flybits servers.
 * Do not register if using [PushService] since it already contains this functionality.
 *
 * Register in manifest using:
 *
 *  <service android:name="com.flybits.android.push.services.FlybitsFirebaseTokenService">
 *      <intent-filter>
 *          <action android:name="com.google.firebase.MESSAGING_EVENT" />
 *      </intent-filter>
 *  </service>
 */
@Deprecated("Deprecated in version 1.19.0, will be removed in version 3.0.0",
    ReplaceWith("FlybitsPushService", "com.flybits.android.push.services"),
    DeprecationLevel.WARNING)
class FlybitsFirebaseTokenService : FirebaseMessagingService() {

    override fun onNewToken(refreshedToken: String?) {
        super.onNewToken(refreshedToken)

        Logger.appendTag(TAG).i("Refreshed token: $refreshedToken")

        if (SharedElementsFactory.get(applicationContext).getSavedJWTToken().isNotEmpty() && refreshedToken != null) {
            PushManager.enablePush(applicationContext, refreshedToken, HashMap(), null, Handler(Looper.getMainLooper()))
        }
    }
}
