/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db.converters;

import android.arch.persistence.room.TypeConverter;
import com.flybits.android.push.models.PushData;
import java.math.BigDecimal;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/flybits/android/push/db/converters/PushDataConverter;", "", "()V", "MAP_ALERT", "", "MAP_BODY", "MAP_ID", "MAP_PUSH_PAYLOAD_ID", "MAP_REQUEST_ID", "MAP_TIMESTAMP", "MAP_TITLE", "MAP_VERSION", "convertJsonToPushData", "Lcom/flybits/android/push/models/PushData;", "json", "convertMapToPushData", "map", "", "push_release"})
public final class PushDataConverter {
    private static final String MAP_ID = "id";
    private static final String MAP_TIMESTAMP = "timestamp";
    private static final String MAP_VERSION = "version";
    private static final String MAP_BODY = "body";
    private static final String MAP_REQUEST_ID = "pushRequestId";
    private static final String MAP_PUSH_PAYLOAD_ID = "pushPayloadTypeId";
    private static final String MAP_ALERT = "alert";
    private static final String MAP_TITLE = "title";
    public static final PushDataConverter INSTANCE;

    @JvmStatic
    @TypeConverter
    @Nullable
    public static final PushData convertMapToPushData(@NotNull Map<String, String> map) {
        JSONObject jSONObject;
        int n;
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        if (!(map.containsKey(MAP_ID) && map.containsKey(MAP_TIMESTAMP) && map.containsKey(MAP_VERSION))) {
            return null;
        }
        try {
            n = Integer.parseInt(map.get(MAP_VERSION));
        }
        catch (NumberFormatException e) {
            n = 2;
        }
        int version = n;
        long timestamp = new BigDecimal(map.get(MAP_TIMESTAMP)).longValue();
        String body = map.get(MAP_BODY);
        try {
            jSONObject = new JSONObject(body);
        }
        catch (JSONException e) {
            jSONObject = new JSONObject();
        }
        JSONObject jsonBody = jSONObject;
        String pushRequestId = jsonBody.optString(MAP_REQUEST_ID);
        String pushPayloadTypeId = jsonBody.has(MAP_PUSH_PAYLOAD_ID) ? jsonBody.getString(MAP_PUSH_PAYLOAD_ID) : null;
        String title = map.containsKey(MAP_TITLE) ? map.get(MAP_TITLE) : null;
        String alert = map.containsKey(MAP_ALERT) ? map.get(MAP_ALERT) : null;
        return new PushData((String)MapsKt.getValue(map, (Object)MAP_ID), pushRequestId, timestamp, version, pushPayloadTypeId, jsonBody, title, alert);
    }

    @JvmStatic
    @TypeConverter
    @Nullable
    public static final PushData convertJsonToPushData(@NotNull String json) {
        JSONObject jSONObject;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            jSONObject = new JSONObject(json);
        }
        catch (JSONException e) {
            return null;
        }
        JSONObject jsonObject = jSONObject;
        if (!(jsonObject.has(MAP_ID) && jsonObject.has(MAP_TIMESTAMP) && jsonObject.has(MAP_VERSION))) {
            return null;
        }
        int version = jsonObject.optInt(MAP_VERSION, 2);
        long timestamp = jsonObject.getLong(MAP_TIMESTAMP);
        String title = jsonObject.optString(MAP_TITLE, null);
        String alert = jsonObject.optString(MAP_ALERT, null);
        JSONObject body = jsonObject.has(MAP_BODY) ? jsonObject.optJSONObject(MAP_BODY) : new JSONObject("{}");
        String pushRequestId = body.optString(MAP_REQUEST_ID, null);
        String pushPayloadTypeId = body.optString(MAP_PUSH_PAYLOAD_ID, null);
        String string = jsonObject.getString(MAP_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject.getString(MAP_ID)");
        JSONObject jSONObject2 = body;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)MAP_BODY);
        return new PushData(string, pushRequestId, timestamp, version, pushPayloadTypeId, jSONObject2, title, alert);
    }

    private PushDataConverter() {
    }

    static {
        PushDataConverter pushDataConverter;
        INSTANCE = pushDataConverter = new PushDataConverter();
    }
}

