package com.flybits.android.push.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;

/**
 * Utilities class that optimizes the process of obtained information associated to a Deep-Link
 * within a Push Notification such as {@code Content} part of
 * {@link com.flybits.android.push.models.pushTypes.ContentMetadata} Notification Type.
 */
public class DeepLinking {

    /**
     * Obtains the identifier of the {@code Content} that was associated to a Push Notification that
     * is comprised of the {@link com.flybits.android.push.models.pushTypes.ContentMetadata}
     * Notification Type. This method simplifies the retrieval of the unique {@code Content}
     * identifier associated to the Push Notification.
     *
     * @param intent The intent that started the {@code Activity} when the notification was
     *               selected.
     *
     * @return The unique {@code Content} identifier associated to the Push Notification, or null
     * if the identifier could not be obtained due to an invalid {@code intent} or {@code context}
     * parameters.
     */
    @Nullable
    public static String parseNotificationIntent(Intent intent, Context context){

        if (intent == null || context == null){
            return null;
        }

        String action = intent.getAction();
        Uri uri =  intent.getData();
        if (Intent.ACTION_VIEW.equals(action) && uri != null) {
            String protocol =  uri.getScheme();
            String server = uri.getAuthority();
            //String path = uri.getPath();
            if (protocol.equalsIgnoreCase("flybits") && server.equalsIgnoreCase(context.getPackageName())){
                return uri.getQueryParameter("id");
            }
        }
        return null;
    }
}
