package com.flybits.android.push.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.flybits.android.push.analytics.PushAnalytics
import com.flybits.android.push.models.newPush.DisplayablePush
import com.flybits.android.push.services.EXTRA_PUSH_NOTIFICATION

/**
 * The [NotificationClickedReceiver] class is launched whenever a user clicks on a Flybits
 * notification from the notification tray. The [PendingIntent] from the notification click should
 * launch the [NotificationClickedReceiver] which will record the push notification click and launch
 * the MAIN activity.
 */
class NotificationClickedReceiver : BroadcastReceiver(){

    override fun onReceive(context: Context, intent: Intent) {
        val packageManager = context.getPackageManager()

        // package manager is provider of all the application information
        val mainIntent = Intent(Intent.ACTION_MAIN, null)
        mainIntent.addCategory(Intent.CATEGORY_LAUNCHER)

        val appList = packageManager.queryIntentActivities(mainIntent, 0)

        val className = appList.find {
            context.packageName == it.activityInfo.packageName
        }?.activityInfo?.name ?: throw ClassNotFoundException()

        val newIntent = Intent(context, Class.forName(className)).apply {
            flags = Intent.FLAG_ACTIVITY_CLEAR_TOP or
                    Intent.FLAG_ACTIVITY_SINGLE_TOP or
                    Intent.FLAG_ACTIVITY_NEW_TASK
        }

        if (intent.hasExtra(EXTRA_PUSH_NOTIFICATION)) {
            intent.extras?.getParcelable<DisplayablePush>(EXTRA_PUSH_NOTIFICATION)?.let{
                newIntent.putExtra(EXTRA_PUSH_NOTIFICATION, it)

                val pushAnalytics = PushAnalytics(context)
                pushAnalytics.trackEngaged(it)
            }
        }

        context.startActivity(newIntent)
    }

}