/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db.converters;

import android.arch.persistence.room.TypeConverter;
import com.flybits.android.push.models.PushData;
import com.flybits.android.push.models.newPush.BasicPush;
import com.flybits.android.push.models.newPush.ContentPush;
import com.flybits.android.push.models.newPush.CustomDisplayablePush;
import com.flybits.android.push.models.newPush.Event;
import com.flybits.android.push.models.newPush.EventPush;
import com.flybits.android.push.models.newPush.Push;
import com.flybits.android.push.models.newPush.WeblinkPush;
import com.flybits.commons.library.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/flybits/android/push/db/converters/PushDataToPushConverter;", "", "()V", "ATTRIBUTE_CONTENT_ID", "", "ATTRIBUTE_CONTENT_VALUE", "ATTRIBUTE_URL", "ENTITY_RELEVANT_CONTENT", "ERROR_INVALID_CONTENT", "ERROR_INVALID_WEB", "ERROR_NULL_REQUEST_ID", "convertPushDataToPush", "Lcom/flybits/android/push/models/newPush/Push;", "pushData", "Lcom/flybits/android/push/models/PushData;", "push_release"})
public final class PushDataToPushConverter {
    private static final String ATTRIBUTE_URL = "url";
    private static final String ATTRIBUTE_CONTENT_ID = "contentId";
    private static final String ATTRIBUTE_CONTENT_VALUE = "value";
    @NotNull
    public static final String ENTITY_RELEVANT_CONTENT = "entityEvent";
    @NotNull
    public static final String ERROR_NULL_REQUEST_ID = "You received a DisplablePush from Flybits that does not contain a RequestID. This should not happen. Please contact support@flybits.com for more details";
    @NotNull
    public static final String ERROR_INVALID_WEB = "You received a WeblinkPush from Flybits that does not contain a url. This should not happen. Please contact support@flybits.com for more details";
    @NotNull
    public static final String ERROR_INVALID_CONTENT = "You received a ContentPush from Flybits that does not contain a Content ID. This should not happen. Please contact support@flybits.com for more details";
    public static final PushDataToPushConverter INSTANCE;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @TypeConverter
    @Nullable
    public static final Push convertPushDataToPush(@NotNull PushData pushData) {
        block17: {
            Intrinsics.checkParameterIsNotNull((Object)pushData, (String)"pushData");
            v0 = pushData.getPushPayloadTypeId();
            if (v0 != null) break block17;
            if (pushData.getPushRequestId() != null) {
                return new BasicPush(pushData.getTimestamp(), pushData.getId(), pushData.getPushRequestId(), pushData.getTitle(), pushData.getMessage());
            }
            ** GOTO lbl23
        }
        var1_1 = v0;
        tmp = -1;
        switch (var1_1.hashCode()) {
            case 1257739383: {
                if (!var1_1.equals("entityEvent")) break;
                tmp = 1;
                break;
            }
            case -540365928: {
                if (!var1_1.equals("4D7484BF-62A3-4D0F-9EF9-C8CF838E2EBA")) break;
                tmp = 2;
                break;
            }
            case -943120620: {
                if (!var1_1.equals("E85691C7-AC1C-431D-995B-4801DDAACE40")) break;
                tmp = 3;
                break;
            }
lbl23:
            // 1 sources

            Logger.e((String)"You received a DisplablePush from Flybits that does not contain a RequestID. This should not happen. Please contact support@flybits.com for more details");
            return null;
        }
        switch (tmp) {
            case 3: {
                jsonBody = pushData.getBody();
                if (!jsonBody.has("url")) {
                    Logger.e((String)"You received a WeblinkPush from Flybits that does not contain a url. This should not happen. Please contact support@flybits.com for more details");
                    return null;
                }
                if (pushData.getPushRequestId() == null) {
                    Logger.e((String)"You received a DisplablePush from Flybits that does not contain a RequestID. This should not happen. Please contact support@flybits.com for more details");
                    return null;
                }
                v1 = pushData.getTimestamp();
                v2 = pushData.getId();
                v3 = pushData.getPushRequestId();
                v4 = pushData.getTitle();
                v5 = pushData.getMessage();
                v6 = jsonBody.getString("url");
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"jsonBody.getString(ATTRIBUTE_URL)");
                return new WeblinkPush(v1, v2, v3, v4, v5, v6);
            }
            case 2: {
                jsonBody = pushData.getBody();
                if (!jsonBody.has("contentId")) {
                    Logger.e((String)"You received a ContentPush from Flybits that does not contain a Content ID. This should not happen. Please contact support@flybits.com for more details");
                    return null;
                }
                if (pushData.getPushRequestId() == null) {
                    Logger.e((String)"You received a DisplablePush from Flybits that does not contain a RequestID. This should not happen. Please contact support@flybits.com for more details");
                    return null;
                }
                jsonContent = jsonBody.getJSONObject("contentId");
                if (!jsonContent.has("value")) {
                    Logger.e((String)"You received a ContentPush from Flybits that does not contain a Content ID. This should not happen. Please contact support@flybits.com for more details");
                    return null;
                }
                v7 = pushData.getTimestamp();
                v8 = pushData.getId();
                v9 = pushData.getPushRequestId();
                v10 = pushData.getTitle();
                v11 = pushData.getMessage();
                v12 = jsonContent.getString("value");
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"jsonContent.getString(ATTRIBUTE_CONTENT_VALUE)");
                return new ContentPush(v7, v8, v9, v10, v11, v12);
            }
            case 1: {
                return new EventPush(pushData.getTimestamp(), pushData.getId(), Event.RELEVANT_CONTENT_CHANGE);
            }
        }
        if (pushData.getPushRequestId() == null) {
            Logger.e((String)"You received a DisplablePush from Flybits that does not contain a RequestID. This should not happen. Please contact support@flybits.com for more details");
            return null;
        }
        return new CustomDisplayablePush(pushData.getTimestamp(), pushData.getId(), pushData.getPushRequestId(), pushData.getPushPayloadTypeId(), pushData.getTitle(), pushData.getMessage(), pushData.getBody());
    }

    private PushDataToPushConverter() {
    }

    static {
        PushDataToPushConverter pushDataToPushConverter;
        INSTANCE = pushDataToPushConverter = new PushDataToPushConverter();
    }
}

