package com.flybits.android.push.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.android.push.models.PushTemplate;
import com.flybits.android.push.utils.PushTemplateQueryParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;

import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;


public class PushTemplateResult extends PagedResult<PushTemplate> {

    public PushTemplateResult(Context context, PagedResultCallback<PushTemplate> callback, ExecutorService service, PushTemplateQueryParameters params, Handler handler){
        super(context, params, callback, handler, service );
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K k, @NotNull PagedResultCallback<PushTemplate> pagedResultCallback) {
        PushTemplate.get(getContext(), (PushTemplateQueryParameters) k, pagedResultCallback);
    }
}
