package com.flybits.android.push.services;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;

import com.flybits.android.push.FlyNotification;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.R;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.newPush.BasicPush;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import java.util.Map;

/**
 * This class has been deprecated. Use {@link PushService} instead.
 * @deprecated in version 1.19.0, will be removed in version 3.0.0.
 * Please use com.flybits.android.push.services.PushService moving forward.
 */
@Deprecated
public class FlybitsPushService extends FirebaseMessagingService {

    private final String _TAG = "FlybitsFirebaseReceiver";
    private final String CHANNEL_ID = "channelFlybitsSDK_ID";
    private final String CHANNEL_NAME = "channelFlybitsSDK";

    @Override
    public void onMessageReceived(final RemoteMessage message){


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, NotificationManager.IMPORTANCE_HIGH);
            NotificationManager notificationManager = (NotificationManager)getApplicationContext().getSystemService(NOTIFICATION_SERVICE);
            if (notificationManager != null)
                notificationManager.createNotificationChannel(notificationChannel);
        }

        Logger.setTag(_TAG).i("FlybitsFCMReceiver->Received Message: " + message.getData());
        Map data = message.getData();
        PushManager.parsePushNotification(getBaseContext(), data, new ObjectResultCallback<Push>() {
            @Override
            public void onSuccess(Push push) {
                Logger.setTag(_TAG).i("Received Flybits Push: " + push.toString());

                BasicPush newPush = new BasicPush(push.getTimestamp(), push.getId(), push.getRequestId(),
                        push.getTitle(), push.getMessage());

                new FlyNotification.Builder(
                        getApplicationContext(),
                        newPush,
                        CHANNEL_ID,
                        getResource()
                ).setTitle(push.getTitle())
                .setBody(push.getMessage())
                .build()
                .show();
            }

            @Override
            public void onException(FlybitsException e) {
                if (e instanceof FlybitsPushException) {
                    if (message.getNotification() != null) {
                        Logger.setTag(_TAG).i("Received FCM Push: " + message.getNotification().getBody());
                        new FlyNotification.Builder(
                                getApplicationContext(),
                                message.getMessageId() ,
                                CHANNEL_ID,
                                getResource()
                        ).setTitle(message.getNotification().getTitle())
                        .setBody(message.getNotification().getBody())
                        .build()
                        .show();
                    }
                }
            }
        });
    }

    private int getResource(){
        try {
            ComponentName myService = new ComponentName(this, this.getClass());
            Bundle bundle = getPackageManager().getServiceInfo(myService, PackageManager.GET_META_DATA).metaData;

            if (bundle.containsKey("com.flybits.push.notification.icon")) {
                return  bundle.getInt("com.flybits.push.notification.icon");
            }
        }catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.exception("FlybitsPushService.getResource", e);
        }
        Logger.setTag(_TAG).w("It appears that you have not set your icon's resource field within your AndroidManifest declaration of the FlybitsPushService. Please visit https://devportal.flybits.com/#/documentation/android/push/push-notifications-receiving for more details.");
        return R.mipmap.ic_flybits_notification;
    }
}
