/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.services;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.Looper;
import com.flybits.android.push.FlyNotification;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.db.converters.PushDataConverter;
import com.flybits.android.push.db.converters.PushDataToPushConverter;
import com.flybits.android.push.models.PushData;
import com.flybits.android.push.models.newPush.DisplayablePush;
import com.flybits.android.push.models.newPush.EventPush;
import com.flybits.android.push.models.newPush.Push;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/flybits/android/push/services/PushService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "ERROR_CONVERSION_PUSHDATA_TO_PUSH", "", "getNotificationChannelId", "push", "Lcom/flybits/android/push/models/newPush/Push;", "getNotificationIconRes", "", "Lcom/flybits/android/push/models/newPush/DisplayablePush;", "onCreateIntent", "Landroid/content/Intent;", "onCreatePendingIntent", "Landroid/app/PendingIntent;", "intent", "onDisplayableFlybitsPushReceived", "", "onEntityFlybitsPushReceived", "Lcom/flybits/android/push/models/newPush/EventPush;", "onMessageReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "onNonFlybitsPushReceived", "showNotification", "pendingIntent", "push_release"})
public abstract class PushService
extends FirebaseMessagingService {
    private final String ERROR_CONVERSION_PUSHDATA_TO_PUSH = "Could Not Parse PushData into Push object. This should not happen. Please contact support@flybits.com for more details";

    public abstract void onNonFlybitsPushReceived(@NotNull RemoteMessage var1);

    public abstract int getNotificationIconRes(@NotNull DisplayablePush var1);

    @NotNull
    public abstract String getNotificationChannelId(@NotNull Push var1);

    public void onMessageReceived(@Nullable RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        RemoteMessage remoteMessage2 = remoteMessage;
        Logger.d((String)("Push received: " + (remoteMessage2 != null ? remoteMessage2.getData() : null)));
        if (remoteMessage != null) {
            try {
                PushData pushData;
                Map map = remoteMessage.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"remoteMessage.data");
                PushData pushData2 = pushData = PushDataConverter.convertMapToPushData(map);
                if (pushData2 != null) {
                    Push push;
                    PushData pushData3 = pushData2;
                    boolean bl = false;
                    boolean bl2 = false;
                    PushData it = pushData3;
                    boolean bl3 = false;
                    Push push2 = push = PushDataToPushConverter.convertPushDataToPush(it);
                    if (push2 != null) {
                        Push push3 = push2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Push itPush = push3;
                        boolean bl6 = false;
                        Push push4 = itPush;
                        if (push4 instanceof DisplayablePush) {
                            this.onDisplayableFlybitsPushReceived((DisplayablePush)itPush);
                        } else if (push4 instanceof EventPush) {
                            this.onEntityFlybitsPushReceived((EventPush)itPush);
                        }
                    } else {
                        Logger.e((String)this.ERROR_CONVERSION_PUSHDATA_TO_PUSH);
                    }
                } else {
                    this.onNonFlybitsPushReceived(remoteMessage);
                }
            }
            catch (FlybitsException e) {
                Logger.exception((String)"ConciergeMessagingService.onMessageReceived()", (Exception)((Exception)((Object)e)));
            }
        }
    }

    public void onNewToken(@Nullable String token) {
        super.onNewToken(token);
        if (token != null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
            CharSequence charSequence = SharedElementsFactory.INSTANCE.get(context).getSavedJWTToken();
            boolean bl = false;
            if (charSequence.length() > 0) {
                Context context2 = this.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"applicationContext");
                PushManager.enablePush(context2, token, new HashMap<String, String>(), null, new Handler(Looper.getMainLooper()));
            }
        }
    }

    @NotNull
    public PendingIntent onCreatePendingIntent(@NotNull Intent intent, @NotNull Push push) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)push.getId().hashCode(), (Intent)intent, (int)0x8000000);
        Intrinsics.checkExpressionValueIsNotNull((Object)pendingIntent, (String)"PendingIntent.getActivit\u2026tent.FLAG_UPDATE_CURRENT)");
        return pendingIntent;
    }

    @NotNull
    public Intent onCreateIntent(@NotNull Push push) {
        Object object;
        Object v2;
        boolean bl;
        Iterable iterable;
        block2: {
            List appList;
            Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
            PackageManager packageManager = this.getApplicationContext().getPackageManager();
            Intent mainIntent = new Intent("android.intent.action.MAIN", null);
            mainIntent.addCategory("android.intent.category.LAUNCHER");
            List list = appList = packageManager.queryIntentActivities(mainIntent, 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"appList");
            iterable = list;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ResolveInfo it = (ResolveInfo)t;
                boolean bl3 = false;
                Context context = this.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
                if (!Intrinsics.areEqual((Object)context.getPackageName(), (Object)it.activityInfo.packageName)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        if ((object = (ResolveInfo)v2) == null || (object = object.activityInfo) == null || (object = object.name) == null) {
            throw (Throwable)new ClassNotFoundException();
        }
        Object className = object;
        iterable = new Intent(this.getApplicationContext(), Class.forName((String)className));
        bl = false;
        boolean bl4 = false;
        Iterable $this$apply = iterable;
        boolean bl5 = false;
        $this$apply.setFlags(0x34000000);
        $this$apply.putExtra("com.flybits.android.push.services.push_notification", push);
        return iterable;
    }

    public void showNotification(@NotNull DisplayablePush push, @NotNull PendingIntent pendingIntent) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        Intrinsics.checkParameterIsNotNull((Object)pendingIntent, (String)"pendingIntent");
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        new FlyNotification.Builder(context, push, this.getNotificationChannelId(push), this.getNotificationIconRes(push)).setPendingIntent(pendingIntent).build().show();
    }

    public void onDisplayableFlybitsPushReceived(@NotNull DisplayablePush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        PendingIntent pendingIntent = this.onCreatePendingIntent(this.onCreateIntent(push), push);
        this.showNotification(push, pendingIntent);
    }

    public void onEntityFlybitsPushReceived(@NotNull EventPush push) {
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
    }
}

