/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.services;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.flybits.android.push.FlyNotification;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.R;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.newPush.BasicPush;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;

@Deprecated
public class FlybitsPushService
extends FirebaseMessagingService {
    private final String _TAG = "FlybitsFirebaseReceiver";
    private final String CHANNEL_ID = "channelFlybitsSDK_ID";
    private final String CHANNEL_NAME = "channelFlybitsSDK";

    public void onMessageReceived(final RemoteMessage message) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel("channelFlybitsSDK_ID", (CharSequence)"channelFlybitsSDK", 4);
            NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(notificationChannel);
            }
        }
        Logger.setTag((String)"FlybitsFirebaseReceiver").i("FlybitsFCMReceiver->Received Message: " + message.getData());
        Map data = message.getData();
        PushManager.parsePushNotification(this.getBaseContext(), data, new ObjectResultCallback<Push>(){

            public void onSuccess(Push push) {
                Logger.setTag((String)"FlybitsFirebaseReceiver").i("Received Flybits Push: " + push.toString());
                BasicPush newPush = new BasicPush(push.getTimestamp(), push.getId(), push.getRequestId(), push.getTitle(), push.getMessage());
                new FlyNotification.Builder(FlybitsPushService.this.getApplicationContext(), newPush, "channelFlybitsSDK_ID", FlybitsPushService.this.getResource()).setTitle(push.getTitle()).setBody(push.getMessage()).build().show();
            }

            public void onException(FlybitsException e) {
                if (e instanceof FlybitsPushException && message.getNotification() != null) {
                    Logger.setTag((String)"FlybitsFirebaseReceiver").i("Received FCM Push: " + message.getNotification().getBody());
                    new FlyNotification.Builder(FlybitsPushService.this.getApplicationContext(), message.getMessageId(), "channelFlybitsSDK_ID", FlybitsPushService.this.getResource()).setTitle(message.getNotification().getTitle()).setBody(message.getNotification().getBody()).build().show();
                }
            }
        });
    }

    private int getResource() {
        try {
            ComponentName myService = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
            Bundle bundle = this.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
            if (bundle.containsKey("com.flybits.push.notification.icon")) {
                return bundle.getInt("com.flybits.push.notification.icon");
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.exception((String)"FlybitsPushService.getResource", (Exception)e);
        }
        Logger.setTag((String)"FlybitsFirebaseReceiver").w("It appears that you have not set your icon's resource field within your AndroidManifest declaration of the FlybitsPushService. Please visit https://devportal.flybits.com/#/documentation/android/push/push-notifications-receiving for more details.");
        return R.mipmap.ic_flybits_notification;
    }
}

