/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db.converters;

import android.arch.persistence.room.TypeConverter;
import com.flybits.commons.library.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lcom/flybits/android/push/db/converters/StringJsonConverter;", "", "()V", "convertJsonToString", "", "json", "Lorg/json/JSONObject;", "convertStringToJson", "push_release"})
public final class StringJsonConverter {
    public static final StringJsonConverter INSTANCE;

    @JvmStatic
    @TypeConverter
    @NotNull
    public static final String convertJsonToString(@NotNull JSONObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = json.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.toString()");
        return string;
    }

    @JvmStatic
    @TypeConverter
    @NotNull
    public static final JSONObject convertStringToJson(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            Logger.setTag((String)"FlybitsRoomConverter").exception("StringJsonConverter#convertStringToJson", (Exception)((Object)e));
            return new JSONObject();
        }
    }

    private StringJsonConverter() {
    }

    static {
        StringJsonConverter stringJsonConverter;
        INSTANCE = stringJsonConverter = new StringJsonConverter();
    }
}

