package com.flybits.android.push.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;

import android.support.annotation.NonNull;
import com.flybits.android.push.db.converters.CustomFieldsConverter;
import com.flybits.android.push.db.converters.PushEnumConverter;
import com.flybits.android.push.db.converters.StringJsonConverter;
import com.flybits.android.push.db.dao.PushDao;
import com.flybits.android.push.db.dao.PushDataDAO;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.PushData;

@Database(entities = {Push.class, PushData.class}, version = 5)
@TypeConverters({PushEnumConverter.class, CustomFieldsConverter.class, StringJsonConverter.class})
public abstract class PushDatabase extends RoomDatabase {

    private static PushDatabase INSTANCE;
    @Deprecated
    public abstract PushDao pushDao();
    public abstract PushDataDAO pushDataDAO();

    public static PushDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = Room.databaseBuilder(context, PushDatabase.class, "flybits-push-db")
                    .addMigrations(MIGRATION_1_3)
                    .addMigrations(MIGRATION_2_3)
                    .addMigrations(MIGRATION_3_4)
                    .addMigrations(MIGRATION_4_5)
                    .fallbackToDestructiveMigration()
                    .build();
        }
        return INSTANCE;
    }

    static final Migration MIGRATION_1_3 = new Migration(1, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE push ADD COLUMN metadataID TEXT");
        }
    };

    static final Migration MIGRATION_2_3 = new Migration(2, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {

            database.execSQL("ALTER TABLE push ADD COLUMN metadataID TEXT");

        }
    };

    static final Migration MIGRATION_3_4 = new Migration(3, 4) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE push");

            String createTableQuery = "CREATE TABLE push ("
                    + Push.COLUMN_DATABASE_ID+" TEXT NOT NULL PRIMARY KEY, "
                    + Push.COLUMN_ACTION+" TEXT NOT NULL, "
                    + Push.COLUMN_CUSTOM_FIELDS+" TEXT, "
                    + Push.COLUMN_CUSTOM_FIELDS_AS_STRING+" TEXT, "
                    + Push.COLUMN_CATEGORY+" TEXT NOT NULL, "
                    + Push.COLUMN_ENTITY+" TEXT, "
                    + Push.COLUMN_ID+" TEXT NOT NULL, "
                    + Push.COLUMN_PUSH_REQUEST_ID+" TEXT NOT NULL,"
                    + Push.COLUMN_MESSAGE+" TEXT, "
                    + Push.COLUMN_TIMESTAMP+" INTEGER NOT NULL, "
                    + Push.COLUMN_TITLE+" TEXT, "
                    + Push.COLUMN_VERSION+" INTEGER NOT NULL, "
                    + Push.COLUMN_META_DATA_ID+" TEXT"
                    + ")";

            database.execSQL(createTableQuery);
        }
    };

    static final Migration MIGRATION_4_5 = new Migration(4, 5) {

        @Override
        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE push");

            String createTableQuery = "CREATE TABLE pushData ("
                    + PushData.COLUMN_ID+" TEXT NOT NULL PRIMARY KEY, "
                    + PushData.COLUMN_PUSH_REQUEST_ID+" TEXT, "
                    + PushData.COLUMN_TIMESTAMP+" INTEGER NOT NULL, "
                    + PushData.COLUMN_VERSION+" INTEGER NOT NULL, "
                    + PushData.COLUMN_PUSH_PAYLOAD_TYPE_ID+" TEXT,"
                    + PushData.COLUMN_BODY+" TEXT NOT NULL, "
                    + PushData.COLUMN_MESSAGE+" TEXT, "
                    + PushData.COLUMN_TITLE+" TEXT"
                    + ")";

            database.execSQL(createTableQuery);

        }
    };
}