/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.paging.LimitOffsetDataSource;
import android.arch.persistence.room.util.StringUtil;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.android.push.db.converters.CustomFieldsConverter;
import com.flybits.android.push.db.converters.PushEnumConverter;
import com.flybits.android.push.db.dao.PushDao;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.PushAction;
import com.flybits.android.push.models.PushCategory;
import com.flybits.android.push.models.PushEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class PushDao_Impl
implements PushDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPush;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPush;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPush;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public PushDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPush = new EntityInsertionAdapter<Push>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `push`(`databaseId`,`action`,`customFields`,`customFieldsAsString`,`category`,`entity`,`id`,`pushRequestId`,`message`,`timestamp`,`title`,`version`,`metadataID`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Push value) {
                if (value.getDatabaseId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDatabaseId());
                }
                String _tmp = PushEnumConverter.actionToString(value.getAction());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = CustomFieldsConverter.actionToString(value.getCustomFields());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getCustomFieldsAsString() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getCustomFieldsAsString());
                }
                String _tmp_2 = PushEnumConverter.categoryToString(value.getCategory());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = PushEnumConverter.entityToString(value.getEntity());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                if (value.getId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getId());
                }
                if (value.getRequestId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getRequestId());
                }
                if (value.getMessage() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getMessage());
                }
                stmt.bindLong(10, value.getTimestamp());
                if (value.getTitle() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getTitle());
                }
                stmt.bindLong(12, value.getVersion());
                if (value.getMetadataID() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getMetadataID());
                }
            }
        };
        this.__deletionAdapterOfPush = new EntityDeletionOrUpdateAdapter<Push>(__db){

            public String createQuery() {
                return "DELETE FROM `push` WHERE `databaseId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Push value) {
                if (value.getDatabaseId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDatabaseId());
                }
            }
        };
        this.__updateAdapterOfPush = new EntityDeletionOrUpdateAdapter<Push>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `push` SET `databaseId` = ?,`action` = ?,`customFields` = ?,`customFieldsAsString` = ?,`category` = ?,`entity` = ?,`id` = ?,`pushRequestId` = ?,`message` = ?,`timestamp` = ?,`title` = ?,`version` = ?,`metadataID` = ? WHERE `databaseId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Push value) {
                if (value.getDatabaseId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDatabaseId());
                }
                String _tmp = PushEnumConverter.actionToString(value.getAction());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = CustomFieldsConverter.actionToString(value.getCustomFields());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getCustomFieldsAsString() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getCustomFieldsAsString());
                }
                String _tmp_2 = PushEnumConverter.categoryToString(value.getCategory());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                String _tmp_3 = PushEnumConverter.entityToString(value.getEntity());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                if (value.getId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getId());
                }
                if (value.getRequestId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getRequestId());
                }
                if (value.getMessage() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getMessage());
                }
                stmt.bindLong(10, value.getTimestamp());
                if (value.getTitle() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getTitle());
                }
                stmt.bindLong(12, value.getVersion());
                if (value.getMetadataID() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getMetadataID());
                }
                if (value.getDatabaseId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getDatabaseId());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM push";
                return "DELETE FROM push";
            }
        };
    }

    @Override
    public void insert(List<Push> pushes) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPush.insert(pushes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(Push push) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPush.insert((Object)push);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Push push) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPush.handle((Object)push);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Push push) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPush.handle((Object)push);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getAll() {
        String _sql = "SELECT * FROM push";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                Push _item = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                _item.setDatabaseId(_tmpDatabaseId);
                String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                _item.setCustomFields(_tmpCustomFields);
                _result.add(_item);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Push getById(String id) {
        String _sql = "SELECT * FROM push WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            Push _result;
            int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            if (_cursor.moveToFirst()) {
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                _result = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                _result.setDatabaseId(_tmpDatabaseId);
                String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                _result.setCustomFields(_tmpCustomFields);
            } else {
                _result = null;
            }
            Push push = _result;
            return push;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getByCachedIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                Push _item_1 = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                _item_1.setDatabaseId(_tmpDatabaseId);
                String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                _item_1.setCustomFields(_tmpCustomFields);
                _result.add(_item_1);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getByCachedIds(List<String> ids, int limit) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                Push _item_1 = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                _item_1.setDatabaseId(_tmpDatabaseId);
                String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                _item_1.setCustomFields(_tmpCustomFields);
                _result.add(_item_1);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<Push> getByIdLive(String id) {
        String _sql = "SELECT * FROM push WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return new ComputableLiveData<Push>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Push compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Push _result;
                    int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
                    int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
                    int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
                    int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
                    int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
                    int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
                    int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
                    int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
                    int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
                    if (_cursor.moveToFirst()) {
                        String _tmp = _cursor.getString(_cursorIndexOfAction);
                        PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                        String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                        PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                        PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                        String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                        _result = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                        String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                        _result.setDatabaseId(_tmpDatabaseId);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                        HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                        _result.setCustomFields(_tmpCustomFields);
                    } else {
                        _result = null;
                    }
                    Push push = _result;
                    return push;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Push>> getLive() {
        String _sql = "SELECT * FROM push";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push", (int)0);
        return new ComputableLiveData<List<Push>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Push> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
                    int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
                    int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
                    int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
                    int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
                    int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
                    int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
                    int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
                    int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
                    ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp = _cursor.getString(_cursorIndexOfAction);
                        PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                        String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                        PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                        PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                        String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                        Push _item = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                        String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                        _item.setDatabaseId(_tmpDatabaseId);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                        HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                        _item.setCustomFields(_tmpCustomFields);
                        _result.add(_item);
                    }
                    ArrayList<Push> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Push>> getLiveByCacheIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new ComputableLiveData<List<Push>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Push> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfDatabaseId = _cursor.getColumnIndexOrThrow("databaseId");
                    int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
                    int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
                    int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
                    int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
                    int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfRequestId = _cursor.getColumnIndexOrThrow("pushRequestId");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
                    int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
                    int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
                    int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
                    ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp = _cursor.getString(_cursorIndexOfAction);
                        PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                        String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCategory);
                        PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfEntity);
                        PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpRequestId = _cursor.getString(_cursorIndexOfRequestId);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                        String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                        Push _item_1 = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
                        String _tmpDatabaseId = _cursor.getString(_cursorIndexOfDatabaseId);
                        _item_1.setDatabaseId(_tmpDatabaseId);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfCustomFields);
                        HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
                        _item_1.setCustomFields(_tmpCustomFields);
                        _result.add(_item_1);
                    }
                    ArrayList<Push> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCountRaw(SupportSQLiteQuery query) {
        SupportSQLiteQuery _internalQuery = query;
        try (Cursor _cursor = this.__db.query(_internalQuery);){
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getRaw(SupportSQLiteQuery query) {
        SupportSQLiteQuery _internalQuery = query;
        try (Cursor _cursor = this.__db.query(_internalQuery);){
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Push _item = this.__entityCursorConverter_comFlybitsAndroidPushModelsPush(_cursor);
                _result.add(_item);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
    }

    @Override
    public LiveData<List<Push>> getLiveRaw(SupportSQLiteQuery query) {
        final SupportSQLiteQuery _internalQuery = query;
        return new ComputableLiveData<List<Push>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Push> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query(_internalQuery);){
                    ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Push _item = PushDao_Impl.this.__entityCursorConverter_comFlybitsAndroidPushModelsPush(_cursor);
                        _result.add(_item);
                    }
                    ArrayList<Push> arrayList = _result;
                    return arrayList;
                }
            }
        }.getLiveData();
    }

    @Override
    public DataSource.Factory<Integer, Push> getDataSourceRaw(SupportSQLiteQuery query) {
        final SupportSQLiteQuery _internalQuery = query;
        return new DataSource.Factory<Integer, Push>(){

            public LimitOffsetDataSource<Push> create() {
                return new LimitOffsetDataSource<Push>(PushDao_Impl.this.__db, _internalQuery, false, new String[]{"push"}){

                    protected List<Push> convertRows(Cursor cursor) {
                        ArrayList<Push> _res = new ArrayList<Push>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Push _item = PushDao_Impl.this.__entityCursorConverter_comFlybitsAndroidPushModelsPush(cursor);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    private Push __entityCursorConverter_comFlybitsAndroidPushModelsPush(Cursor cursor) {
        PushEntity _tmpEntity;
        PushCategory _tmpCategory;
        PushAction _tmpAction;
        int _cursorIndexOfDatabaseId = cursor.getColumnIndex("databaseId");
        int _cursorIndexOfAction = cursor.getColumnIndex("action");
        int _cursorIndexOfCustomFields = cursor.getColumnIndex("customFields");
        int _cursorIndexOfCustomFieldsAsString = cursor.getColumnIndex("customFieldsAsString");
        int _cursorIndexOfCategory = cursor.getColumnIndex("category");
        int _cursorIndexOfEntity = cursor.getColumnIndex("entity");
        int _cursorIndexOfId = cursor.getColumnIndex("id");
        int _cursorIndexOfRequestId = cursor.getColumnIndex("pushRequestId");
        int _cursorIndexOfMessage = cursor.getColumnIndex("message");
        int _cursorIndexOfTimestamp = cursor.getColumnIndex("timestamp");
        int _cursorIndexOfTitle = cursor.getColumnIndex("title");
        int _cursorIndexOfVersion = cursor.getColumnIndex("version");
        int _cursorIndexOfMetadataID = cursor.getColumnIndex("metadataID");
        if (_cursorIndexOfAction == -1) {
            _tmpAction = null;
        } else {
            String _tmp = cursor.getString(_cursorIndexOfAction);
            _tmpAction = PushEnumConverter.fromActionString(_tmp);
        }
        String _tmpCustomFieldsAsString = _cursorIndexOfCustomFieldsAsString == -1 ? null : cursor.getString(_cursorIndexOfCustomFieldsAsString);
        if (_cursorIndexOfCategory == -1) {
            _tmpCategory = null;
        } else {
            String _tmp_1 = cursor.getString(_cursorIndexOfCategory);
            _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_1);
        }
        if (_cursorIndexOfEntity == -1) {
            _tmpEntity = null;
        } else {
            String _tmp_2 = cursor.getString(_cursorIndexOfEntity);
            _tmpEntity = PushEnumConverter.fromEntityString(_tmp_2);
        }
        String _tmpId = _cursorIndexOfId == -1 ? null : cursor.getString(_cursorIndexOfId);
        String _tmpRequestId = _cursorIndexOfRequestId == -1 ? null : cursor.getString(_cursorIndexOfRequestId);
        String _tmpMessage = _cursorIndexOfMessage == -1 ? null : cursor.getString(_cursorIndexOfMessage);
        long _tmpTimestamp = _cursorIndexOfTimestamp == -1 ? 0L : cursor.getLong(_cursorIndexOfTimestamp);
        String _tmpTitle = _cursorIndexOfTitle == -1 ? null : cursor.getString(_cursorIndexOfTitle);
        long _tmpVersion = _cursorIndexOfVersion == -1 ? 0L : cursor.getLong(_cursorIndexOfVersion);
        String _tmpMetadataID = _cursorIndexOfMetadataID == -1 ? null : cursor.getString(_cursorIndexOfMetadataID);
        Push _entity = new Push(_tmpId, _tmpEntity, _tmpAction, _tmpCategory, _tmpRequestId, _tmpVersion, _tmpTimestamp, _tmpTitle, _tmpMessage, _tmpCustomFieldsAsString, _tmpMetadataID);
        if (_cursorIndexOfDatabaseId != -1) {
            String _tmpDatabaseId = cursor.getString(_cursorIndexOfDatabaseId);
            _entity.setDatabaseId(_tmpDatabaseId);
        }
        if (_cursorIndexOfCustomFields != -1) {
            String _tmp_3 = cursor.getString(_cursorIndexOfCustomFields);
            HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_3);
            _entity.setCustomFields(_tmpCustomFields);
        }
        return _entity;
    }
}

