package com.flybits.android.push;

import com.flybits.android.push.services.FlybitsPushService;

public class FlyingPushConstants {

     /**
     * The Intent action that can be subscribed to for any push notification associated to the
     * {@link com.flybits.android.push.models.PushCategory#CUSTOM} category.
     */
    public static final String ACTION_PUSH_CUSTOM = "com.flybits.action.push.custom";

    /**
     *
     */
    public static final String EXTRA_PUSH_NOTIFICATION                  = "com.flybits.extra.push";

    /**
     * The Intent action that can be subscribed to for any push notification associated to the
     * {@link com.flybits.android.push.models.PushCategory#KERNEL} category.
     */
    public static final String INTERNAL_ACTION_PUSH_KERNEL = "com.flybits.action.push.core";

    /**
     * The Intent action that can be subscribed to for any push notification associated to the
     * {@link com.flybits.android.push.models.PushCategory#CONTEXT} category.
     */
    public static final String INTERNAL_ACTION_PUSH_CONTEXT = "com.flybits.action.push.context";

    /**
     * This Intent Action is activated when a Flybits Push Notification is received. Once the
     * {@link FlybitsPushService} receives a Flybits
     * notification it broadcasts it to the application in case it needs to do it's own processing.
     */
    public static final String ACTION_PUSH_RECEIVED_FLYBITS = "com.flybits.action.push.received.flybits";

    /**
     * This Intent Action is activated when a FCM Push Notification is received. Once the
     * {@link FlybitsPushService} receives a FCM
     * notification it broadcasts it to the application in case it needs to do it's own processing.
     */
    public static final String ACTION_PUSH_RECEIVED_FCM = "com.flybits.action.push.received.fcm";

    /**
     * Default value for empty Preference options.
     */
    public static final String PREF_DEFAULT_EMPTY_STRING     = "";

    /**
     *
     */
    public static final String PREF_PUSH_SERVICE_URI         = "com.flybits.push.service.URI";
}
