package com.flybits.android.push.services;

import android.content.Context;

import com.flybits.android.push.PushManager;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.google.firebase.messaging.FirebaseMessagingService;

import static com.flybits.android.push.models.PushToken.API;

public class FlybitsFirebaseTokenService extends FirebaseMessagingService {

    private static final String _TAG = "FlybitsFirebaseTokenService";

    @Override
    public void onNewToken(String refreshedToken) {
        super.onNewToken(refreshedToken);

        //Displaying token on logcat
        Logger.setTag(_TAG).i("Refreshed token: " + refreshedToken);
        SharedElements sharedElements = SharedElements.get(getApplicationContext());
        if (sharedElements.getSavedJWTToken() != null
                && sharedElements.getSavedJWTToken().length() > 0) {
            sendRegistrationToServer(getBaseContext(), refreshedToken);
        }
    }

    private Result sendRegistrationToServer(Context context, String token) {

        try {
            PushToken resultSerializationObj    = new PushToken(token, null);
            DeserializePushToken deserialization = new DeserializePushToken();
            final String json = deserialization.toJson(resultSerializationObj);
            return FlyAway.post(context, API, json, null, "PushManager.enableFCM", null);
        }catch (FlybitsException e){
            return null;
        }
    }
}
