/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.deserializations;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.android.push.models.PushTemplate;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.deserializations.IDeserializer;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializePushTemplate
extends IDeserializer<PushTemplate> {
    private Context context;

    public DeserializePushTemplate(Context context) {
        this.context = context;
    }

    public PushTemplate fromJson(JSONObject jObj) {
        try {
            JSONArray jsonArrayUsers;
            JSONObject object;
            JSONArray jsonArrayRules;
            String name = jObj.getString("name");
            String action = null;
            String title = null;
            String message = null;
            JSONArray arrayOfData = jObj.getJSONArray("body");
            for (int i = 0; i < arrayOfData.length(); ++i) {
                JSONObject jsonAlert;
                JSONObject jsonPayload = arrayOfData.getJSONObject(0);
                if (jsonPayload.isNull("payload")) continue;
                JSONObject jsonMessage = jsonPayload.getJSONObject("payload");
                if (!jsonMessage.isNull("title")) {
                    jsonAlert = jsonMessage.getJSONObject("title");
                    title = jsonAlert.getString("en");
                }
                if (!jsonMessage.isNull("alert")) {
                    jsonAlert = jsonMessage.getJSONObject("alert");
                    message = jsonAlert.getString("en");
                }
                action = jsonMessage.getString("action");
            }
            PushTemplate.Builder builder = new PushTemplate.Builder(this.context, name, title, message).setAction(action);
            for (int i = 0; i < arrayOfData.length(); ++i) {
                JSONObject jsonMessage;
                JSONObject jsonPayload = arrayOfData.getJSONObject(0);
                if (jsonPayload.isNull("payload") || (jsonMessage = jsonPayload.getJSONObject("payload")).isNull("data")) continue;
                JSONObject objData = jsonMessage.getJSONObject("data");
                Iterator keys = objData.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    builder.addCustomField(key, objData.get(key).toString());
                    keys.remove();
                }
            }
            if (!jObj.isNull("pushRequestID")) {
                builder.setID(jObj.getString("pushRequestID"));
            }
            if (!jObj.isNull("rules") && (jsonArrayRules = jObj.getJSONArray("rules")).length() > 0) {
                for (int i = 0; i < jsonArrayRules.length(); ++i) {
                    object = jsonArrayRules.getJSONObject(i);
                    builder.addRule(object.getString("ruleID"), PushTemplate.ResultType.fromKey(object.getInt("result")));
                }
            }
            if (!jObj.isNull("Recipients") && (jsonArrayUsers = jObj.getJSONArray("Recipients")).length() > 0) {
                for (int i = 0; i < jsonArrayUsers.length(); ++i) {
                    object = jsonArrayUsers.getJSONObject(i);
                    builder.addUser(object.getString("userID"), object.getString("deviceID"));
                }
            }
            if (!jObj.isNull("options") && !jObj.isNull("options")) {
                JSONObject jsonObjectOptions = jObj.getJSONObject("options");
                builder.setOptions(jsonObjectOptions.getInt("max"), jsonObjectOptions.getInt("delay"), jsonObjectOptions.getInt("cooldown"));
            }
            return builder.build();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public PushTemplate fromJson(JSONArray jsonArray) {
        return null;
    }

    public String toJson(@NonNull PushTemplate obj) {
        JSONObject objRules;
        Map.Entry<String, Object> pair3;
        JSONObject jsonPayload;
        JSONObject jsonObject;
        block48: {
            if (obj == null) {
                return "{}";
            }
            jsonObject = new JSONObject();
            try {
                jsonObject.put("tenantID", (Object)SharedElements.INSTANCE.getProjectID(this.context));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSONObject titleObj = new JSONObject();
            try {
                titleObj.put("en", (Object)obj.getTitle());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSONObject messageObj = new JSONObject();
            try {
                messageObj.put("en", (Object)obj.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            jsonPayload = new JSONObject();
            try {
                jsonPayload.put("action", (Object)obj.getAction());
                jsonPayload.put("title", (Object)titleObj);
                jsonPayload.put("alert", (Object)messageObj);
                if (obj.getCustomFields().size() <= 0) break block48;
                JSONObject customFieldsObject = new JSONObject();
                Iterator<Map.Entry<String, String>> itCustom = obj.getCustomFields().entrySet().iterator();
                while (itCustom.hasNext()) {
                    Map.Entry<String, String> pair2 = itCustom.next();
                    try {
                        customFieldsObject.put(pair2.getKey(), (Object)pair2.getValue());
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    itCustom.remove();
                }
                jsonPayload.put("data", (Object)customFieldsObject);
            }
            catch (JSONException customFieldsObject) {
                // empty catch block
            }
        }
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("payload", (Object)jsonPayload);
            jsonBody.put("weight", 100);
        }
        catch (JSONException itCustom) {
            // empty catch block
        }
        JSONArray jsonBodyArray = new JSONArray();
        jsonBodyArray.put((Object)jsonBody);
        try {
            jsonObject.put("body", (Object)jsonBodyArray);
        }
        catch (JSONException pair2) {
            // empty catch block
        }
        try {
            jsonObject.put("backgroundPushType", 1);
        }
        catch (JSONException pair2) {
            // empty catch block
        }
        try {
            jsonObject.put("name", (Object)obj.getName());
        }
        catch (JSONException pair2) {
            // empty catch block
        }
        try {
            jsonObject.put("pushType", 3);
        }
        catch (JSONException pair2) {
            // empty catch block
        }
        if (obj.getListOfRules().size() > 0) {
            JSONArray arrayRules = new JSONArray();
            Iterator<Map.Entry<String, Integer>> it = obj.getListOfRules().entrySet().iterator();
            while (it.hasNext()) {
                pair3 = it.next();
                objRules = new JSONObject();
                try {
                    objRules.put("ruleID", (Object)pair3.getKey());
                    objRules.put("result", pair3.getValue());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                arrayRules.put((Object)objRules);
                it.remove();
            }
            try {
                jsonObject.put("rules", (Object)arrayRules);
            }
            catch (JSONException pair3) {
                // empty catch block
            }
        }
        if (obj.getListOfUsers().size() > 0) {
            JSONArray arrayRecipients = new JSONArray();
            Iterator<Map.Entry<String, String>> it2 = obj.getListOfUsers().entrySet().iterator();
            while (it2.hasNext()) {
                pair3 = it2.next();
                objRules = new JSONObject();
                try {
                    objRules.put("userID", (Object)pair3.getKey());
                    objRules.put("deviceID", pair3.getValue());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                arrayRecipients.put((Object)objRules);
                it2.remove();
            }
            try {
                jsonObject.put("Recipients", (Object)arrayRecipients);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (obj.getOptions() != null) {
            JSONObject jsonOptions = new JSONObject();
            try {
                if (obj.getOptions().getMax() > -1) {
                    jsonOptions.put("max", obj.getOptions().getMax());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                if (obj.getOptions().getDelay() > -1) {
                    jsonOptions.put("delay", obj.getOptions().getDelay());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                if (obj.getOptions().getCooldown() > -1) {
                    jsonOptions.put("cooldown", obj.getOptions().getCooldown());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                jsonOptions.put("sampling", 0);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                jsonObject.put("options", (Object)jsonOptions);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jsonObject.toString();
    }
}

