/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.db.PushDatabase;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.User;
import java.util.HashMap;

public class PushScope
extends FlybitsScope {
    public static final String ROOT = "/push";
    public static PushScope SCOPE = new PushScope();
    private HashMap<String, String> properties;
    private boolean autoConnectToPush = true;

    PushScope() {
        super("PushScope");
    }

    public PushScope(HashMap<String, String> properties) {
        this();
        this.properties = properties;
    }

    public PushScope(boolean autoConnect) {
        this();
        this.autoConnectToPush = autoConnect;
    }

    public void onConnected(Context context, User user) {
        if (this.autoConnectToPush) {
            PushManager.enableFCMPush(context, this.properties, null);
        }
    }

    public void onDisconnected(final Context context, String jwtToken) {
        if (this.autoConnectToPush) {
            PushManager.disablePush(context, jwtToken, new BasicResultCallback(){

                public void onSuccess() {
                    PushScope.this.clearPushPreferences(context);
                }

                public void onException(FlybitsException exception) {
                }
            });
        }
    }

    public void onAccountDestroyed(Context context, String jwtToken) {
        this.onDisconnected(context, jwtToken);
    }

    public static SharedPreferences getPushPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF_PUSH", 0);
    }

    private void clearPushPreferences(Context context) {
        SharedPreferences.Editor preferences = PushScope.getPushPreferences(context).edit();
        preferences.clear();
        preferences.apply();
        new ClearDatabase(context).execute(new Void[0]);
    }

    private class ClearDatabase
    extends AsyncTask<Void, Void, Void> {
        private Context context;

        public ClearDatabase(Context context) {
            this.context = context;
        }

        protected Void doInBackground(Void ... urls) {
            PushDatabase.getDatabase(this.context).pushDao().clear();
            return null;
        }
    }
}

