/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.db.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.util.StringUtil;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.android.push.db.converters.CustomFieldsConverter;
import com.flybits.android.push.db.converters.PushEnumConverter;
import com.flybits.android.push.db.dao.PushDao;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.PushAction;
import com.flybits.android.push.models.PushCategory;
import com.flybits.android.push.models.PushEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class PushDao_Impl
implements PushDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPush;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPush;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPush;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public PushDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPush = new EntityInsertionAdapter<Push>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `push`(`action`,`customFields`,`customFieldsAsString`,`category`,`entity`,`id`,`message`,`timestamp`,`title`,`version`,`metadataID`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Push value) {
                String _tmp = PushEnumConverter.actionToString(value.getAction());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = CustomFieldsConverter.actionToString(value.getCustomFields());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getCustomFieldsAsString() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCustomFieldsAsString());
                }
                String _tmp_2 = PushEnumConverter.categoryToString(value.getCategory());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = PushEnumConverter.entityToString(value.getEntity());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getId());
                }
                if (value.getMessage() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMessage());
                }
                stmt.bindLong(8, value.getTimestamp());
                if (value.getTitle() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTitle());
                }
                stmt.bindLong(10, value.getVersion());
                if (value.getMetadataID() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getMetadataID());
                }
            }
        };
        this.__deletionAdapterOfPush = new EntityDeletionOrUpdateAdapter<Push>(__db){

            public String createQuery() {
                return "DELETE FROM `push` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Push value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
            }
        };
        this.__updateAdapterOfPush = new EntityDeletionOrUpdateAdapter<Push>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `push` SET `action` = ?,`customFields` = ?,`customFieldsAsString` = ?,`category` = ?,`entity` = ?,`id` = ?,`message` = ?,`timestamp` = ?,`title` = ?,`version` = ?,`metadataID` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Push value) {
                String _tmp = PushEnumConverter.actionToString(value.getAction());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = CustomFieldsConverter.actionToString(value.getCustomFields());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getCustomFieldsAsString() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCustomFieldsAsString());
                }
                String _tmp_2 = PushEnumConverter.categoryToString(value.getCategory());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = PushEnumConverter.entityToString(value.getEntity());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getId());
                }
                if (value.getMessage() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMessage());
                }
                stmt.bindLong(8, value.getTimestamp());
                if (value.getTitle() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTitle());
                }
                stmt.bindLong(10, value.getVersion());
                if (value.getMetadataID() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getMetadataID());
                }
                if (value.getId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getId());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM push";
                return "DELETE FROM push";
            }
        };
    }

    @Override
    public void insert(List<Push> pushes) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPush.insert(pushes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(Push push) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPush.insert((Object)push);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Push push) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPush.handle((Object)push);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Push push) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPush.handle((Object)push);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getAll() {
        String _sql = "SELECT * FROM push";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Push _item = new Push();
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                _item.setAction(_tmpAction);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                _item.setCustomFields(_tmpCustomFields);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                _item.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                _item.setCategory(_tmpCategory);
                String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                _item.setEntity(_tmpEntity);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                _item.setMessage(_tmpMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                _item.setVersion(_tmpVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                _item.setMetadataID(_tmpMetadataID);
                _result.add(_item);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Push getById(String id) {
        String _sql = "SELECT * FROM push WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            Push _result;
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            if (_cursor.moveToFirst()) {
                _result = new Push();
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                _result.setAction(_tmpAction);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                _result.setCustomFields(_tmpCustomFields);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                _result.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                _result.setCategory(_tmpCategory);
                String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                _result.setEntity(_tmpEntity);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                _result.setMessage(_tmpMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _result.setTitle(_tmpTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                _result.setVersion(_tmpVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                _result.setMetadataID(_tmpMetadataID);
            } else {
                _result = null;
            }
            Push push = _result;
            return push;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getByCachedIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Push _item_1 = new Push();
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                _item_1.setAction(_tmpAction);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                _item_1.setCustomFields(_tmpCustomFields);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                _item_1.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                _item_1.setCategory(_tmpCategory);
                String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                _item_1.setEntity(_tmpEntity);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                _item_1.setMessage(_tmpMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item_1.setTimestamp(_tmpTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item_1.setTitle(_tmpTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                _item_1.setVersion(_tmpVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                _item_1.setMetadataID(_tmpMetadataID);
                _result.add(_item_1);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Push> getByCachedIds(List<String> ids, int limit) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
            int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
            int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
            int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
            int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
            int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
            int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
            int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
            int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
            ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Push _item_1 = new Push();
                String _tmp = _cursor.getString(_cursorIndexOfAction);
                PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                _item_1.setAction(_tmpAction);
                String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                _item_1.setCustomFields(_tmpCustomFields);
                String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                _item_1.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                _item_1.setCategory(_tmpCategory);
                String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                _item_1.setEntity(_tmpEntity);
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                _item_1.setMessage(_tmpMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item_1.setTimestamp(_tmpTimestamp);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item_1.setTitle(_tmpTitle);
                long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                _item_1.setVersion(_tmpVersion);
                String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                _item_1.setMetadataID(_tmpMetadataID);
                _result.add(_item_1);
            }
            ArrayList<Push> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<Push> getByIdLive(String id) {
        String _sql = "SELECT * FROM push WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return new ComputableLiveData<Push>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Push compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Push _result;
                    int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
                    int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
                    int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
                    int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
                    int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
                    int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
                    int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
                    int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
                    if (_cursor.moveToFirst()) {
                        _result = new Push();
                        String _tmp = _cursor.getString(_cursorIndexOfAction);
                        PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                        _result.setAction(_tmpAction);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                        HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                        _result.setCustomFields(_tmpCustomFields);
                        String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                        _result.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                        PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                        _result.setCategory(_tmpCategory);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                        PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                        _result.setEntity(_tmpEntity);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        _result.setMessage(_tmpMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _result.setTimestamp(_tmpTimestamp);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        _result.setTitle(_tmpTitle);
                        long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                        _result.setVersion(_tmpVersion);
                        String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                        _result.setMetadataID(_tmpMetadataID);
                    } else {
                        _result = null;
                    }
                    Push push = _result;
                    return push;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Push>> getLive() {
        String _sql = "SELECT * FROM push";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM push", (int)0);
        return new ComputableLiveData<List<Push>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Push> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
                    int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
                    int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
                    int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
                    int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
                    int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
                    int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
                    int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
                    ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Push _item = new Push();
                        String _tmp = _cursor.getString(_cursorIndexOfAction);
                        PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                        _item.setAction(_tmpAction);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                        HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                        _item.setCustomFields(_tmpCustomFields);
                        String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                        _item.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                        PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                        _item.setCategory(_tmpCategory);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                        PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                        _item.setEntity(_tmpEntity);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        _item.setMessage(_tmpMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        _item.setTitle(_tmpTitle);
                        long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                        _item.setVersion(_tmpVersion);
                        String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                        _item.setMetadataID(_tmpMetadataID);
                        _result.add(_item);
                    }
                    ArrayList<Push> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Push>> getLiveByCacheIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new ComputableLiveData<List<Push>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Push> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("push", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PushDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PushDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfAction = _cursor.getColumnIndexOrThrow("action");
                    int _cursorIndexOfCustomFields = _cursor.getColumnIndexOrThrow("customFields");
                    int _cursorIndexOfCustomFieldsAsString = _cursor.getColumnIndexOrThrow("customFieldsAsString");
                    int _cursorIndexOfCategory = _cursor.getColumnIndexOrThrow("category");
                    int _cursorIndexOfEntity = _cursor.getColumnIndexOrThrow("entity");
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfMessage = _cursor.getColumnIndexOrThrow("message");
                    int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
                    int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("title");
                    int _cursorIndexOfVersion = _cursor.getColumnIndexOrThrow("version");
                    int _cursorIndexOfMetadataID = _cursor.getColumnIndexOrThrow("metadataID");
                    ArrayList<Push> _result = new ArrayList<Push>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Push _item_1 = new Push();
                        String _tmp = _cursor.getString(_cursorIndexOfAction);
                        PushAction _tmpAction = PushEnumConverter.fromActionString(_tmp);
                        _item_1.setAction(_tmpAction);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfCustomFields);
                        HashMap<String, String> _tmpCustomFields = CustomFieldsConverter.fromMapString(_tmp_1);
                        _item_1.setCustomFields(_tmpCustomFields);
                        String _tmpCustomFieldsAsString = _cursor.getString(_cursorIndexOfCustomFieldsAsString);
                        _item_1.setCustomFieldsAsString(_tmpCustomFieldsAsString);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfCategory);
                        PushCategory _tmpCategory = PushEnumConverter.fromCategoryString(_tmp_2);
                        _item_1.setCategory(_tmpCategory);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfEntity);
                        PushEntity _tmpEntity = PushEnumConverter.fromEntityString(_tmp_3);
                        _item_1.setEntity(_tmpEntity);
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item_1.setId(_tmpId);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        _item_1.setMessage(_tmpMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item_1.setTimestamp(_tmpTimestamp);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        _item_1.setTitle(_tmpTitle);
                        long _tmpVersion = _cursor.getLong(_cursorIndexOfVersion);
                        _item_1.setVersion(_tmpVersion);
                        String _tmpMetadataID = _cursor.getString(_cursorIndexOfMetadataID);
                        _item_1.setMetadataID(_tmpMetadataID);
                        _result.add(_item_1);
                    }
                    ArrayList<Push> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM push WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

