package com.flybits.android.push.models.results;

import android.content.Context;
import android.os.Handler;

import com.flybits.android.push.models.PushTemplate;
import com.flybits.android.push.utils.PushTemplateQueryParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;

import java.util.concurrent.ExecutorService;


public class PushTemplateResult extends PagedResult<PushTemplate> {


    public PushTemplateResult(Context context, PagedResultCallback<PushTemplate> callback){
        super(context, callback);
    }

    public PushTemplateResult(Context context, PagedResultCallback<PushTemplate> callback, ExecutorService service){
        super(context, callback, service);
    }

    public PushTemplateResult(Context context, PagedResultCallback<PushTemplate> callback, ExecutorService service, PushTemplateQueryParameters params, Handler handler){
        super(context, params, callback, service, handler);
    }

    @Override
    protected <K extends QueryParameters> PushTemplateResult getMore(Context context, K parameters,
                                                       PagedResultCallback<PushTemplate> callback) {

        return PushTemplate.get(context, (PushTemplateQueryParameters) parameters, callback);
    }
}
