/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.Result;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushToken
implements Parcelable {
    public static final String API = "/push/token";
    private HashMap<String, String> data;
    private String deviceToken;
    private long network;
    public static final Parcelable.Creator<PushToken> CREATOR = new Parcelable.Creator<PushToken>(){

        public PushToken createFromParcel(Parcel in) {
            return new PushToken(in);
        }

        public PushToken[] newArray(int size) {
            return new PushToken[size];
        }
    };

    public PushToken(@NonNull String token) {
        this.deviceToken = token;
        this.network = 1L;
    }

    public HashMap<String, String> getData() {
        return this.data;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public long getType() {
        return this.network;
    }

    public PushToken(String token, HashMap<String, String> data) {
        this.deviceToken = token;
        this.network = 1L;
        this.data = data;
    }

    protected PushToken(Parcel in) {
        this.deviceToken = in.readString();
        this.network = in.readLong();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.deviceToken);
        out.writeLong(this.network);
    }

    public static ObjectResult<PushToken> get(final @NonNull Context context, ObjectResultCallback<PushToken> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult query = new ObjectResult(context, callback, executorService, handler);
        query.setService(executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result result = FlyAway.get((Context)context, (String)PushToken.API, (IDeserializer)new DeserializePushToken(), (String)"PushToken.get", PushToken.class);
                    query.setResult(result);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }
}

