package com.flybits.android.push.models.pushTypes;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * The {@code ContentMetadata} class is responsible for defining all the attributes associated to
 * the {@code Content} Notification Type defined within the Developer Portal and Experience Studio.
 * This Notification Type contains a Content ID that indicates a piece of {@code Content} that
 * should be launched if the end-user selects the Notification. Once in the application it is the
 * responsibility of the application to take the end-user to the proper {@code Content} deep link.
 */
public class ContentMetadata extends NotificationMetadata {

    private String contentId;

    /**
     * Default Constructor used to generate this {@code ContentMetadata} object.
     *
     * @param json The JSON String that needs to be processed in order to generate values for the
     *             attributes defined in this class.
     */
    public ContentMetadata(String json) {
        super(json);
    }

    /**
     * Get the identifier that represents a specific piece of {@code Content}.
     *
     * @return The identifier that represents a specific piece of {@code Content}.
     */
    public String getContentId() {
        return contentId;
    }

    @Override
    public void fromJSON(String json) {
        try{
            JSONObject jsonObject = new JSONObject(json);
            if (!jsonObject.isNull("contentId")) {
                JSONObject content = jsonObject.getJSONObject("contentId");
                if (content.getString("entity").equalsIgnoreCase("content")) {
                    this.contentId = content.getString("value");
                }
            }
        }catch (JSONException exception){}
    }

    @Override
    public PendingIntent onClick(Context context){
        Intent resultIntent = new Intent(Intent.ACTION_VIEW);
        resultIntent.setData(Uri.parse("flybits://"+context.getPackageName()+"/content?id=" + getContentId()));
        return PendingIntent.getActivity(context, 0, resultIntent, PendingIntent.FLAG_UPDATE_CURRENT);
    }
}
