package com.flybits.android.push.models;

/**
 * The Entity that the Push notification directly affects.
 */
public enum PushEntity {

    /**
     * Indicates that a push notification was delivered with a custom body response.
     */
    CUSTOM("custom"),

    /**
     * Indicates that the push notification directly affects a Context {@code Rule}.
     */
    RULE("rule"),

    /**
     * Indicates that the push notification directly affects an Experience.
     */
    EXPERIENCE("experience"),

    /**
     * Indicates that a unknown push notification was received from the Flybits Push Server.
     */
    UNKNOWN("N/A");

    private final String key;

    /**
     * Constructor that defines the key for each {@code PushEntity} option.
     *
     * @param key the string value representing each {@code PushEntity} option.
     */
    PushEntity(String key) {
        this.key = key;
    }

    /**
     * Get the string representation for the {@code PushEntity} option.
     *
     * @return string representation of the {@code PushEntity} option.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Get the {@code PushEntity} enum value corresponding to an String representation.
     *
     * @param key the string representation of the {@code PushEntity} enum.
     *
     * @return The {@code PushEntity} enum for the String representation.
     */
    public static PushEntity fromKey(String key) {
        if (key == null){
            return UNKNOWN;
        }

        for(PushEntity type : PushEntity.values()) {
            if(type.getKey().equalsIgnoreCase(key)) {
                return type;
            }
        }
        return UNKNOWN;
    }
}

