/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.db.PushDatabase;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.User;
import java.util.HashMap;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0007\b\u0000\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011J%\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/flybits/android/push/PushScope;", "Lcom/flybits/commons/library/api/FlybitsScope;", "properties", "Ljava/util/HashMap;", "", "(Ljava/util/HashMap;)V", "autoConnect", "", "(Z)V", "()V", "autoConnectToPush", "clearData", "", "context", "Landroid/content/Context;", "clearData$push_release", "clearDataAsync", "clearDataAsync$push_release", "disableThenClearData", "jwt", "handler", "Landroid/os/Handler;", "disableThenClearData$push_release", "onAccountDestroyed", "jwtToken", "onConnected", "user", "Lcom/flybits/commons/library/models/User;", "onDisconnected", "onOptedStateChange", "optedState", "Companion", "push_release"})
public final class PushScope
extends FlybitsScope {
    private HashMap<String, String> properties;
    private boolean autoConnectToPush;
    @NotNull
    public static final String PUSH_PREF = "FLYBITS_PREF_PUSH";
    @NotNull
    public static final String ROOT = "/push";
    @NotNull
    private static final PushScope SCOPE;
    public static final Companion Companion;

    public void onConnected(@NotNull Context context, @NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (this.autoConnectToPush) {
            PushManager.enableFCMPush(context, this.properties, null);
        }
    }

    public void onDisconnected(@NotNull Context context, @NotNull String jwtToken) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)jwtToken, (String)"jwtToken");
        this.disableThenClearData$push_release(context, jwtToken, new Handler(Looper.getMainLooper()));
    }

    public void onAccountDestroyed(@NotNull Context context, @NotNull String jwtToken) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)jwtToken, (String)"jwtToken");
        this.disableThenClearData$push_release(context, jwtToken, new Handler(Looper.getMainLooper()));
    }

    public void onOptedStateChange(@NotNull Context context, boolean optedState) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!optedState) {
            this.clearDataAsync$push_release(context);
        }
    }

    public final void disableThenClearData$push_release(@NotNull Context context, @NotNull String jwt, @NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)jwt, (String)"jwt");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        if (this.autoConnectToPush) {
            PushManager.disablePush(context, jwt, new BasicResultCallback(this, context){
                final /* synthetic */ PushScope this$0;
                final /* synthetic */ Context $context;

                public void onSuccess() {
                    this.this$0.clearDataAsync$push_release(this.$context);
                }

                public void onException(@NotNull FlybitsException exception) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
                }
                {
                    this.this$0 = $outer;
                    this.$context = $captured_local_variable$1;
                }
            }, handler);
        }
    }

    public final void clearDataAsync$push_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Executors.newSingleThreadExecutor().execute(new Runnable(this, context){
            final /* synthetic */ PushScope this$0;
            final /* synthetic */ Context $context;

            public final void run() {
                this.this$0.clearData$push_release(this.$context);
            }
            {
                this.this$0 = pushScope;
                this.$context = context;
            }
        });
    }

    public final void clearData$push_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences.Editor preferences = Companion.getPushPreferences(context).edit();
        preferences.clear();
        preferences.apply();
        PushDatabase.getDatabase(context).pushDao().clear();
    }

    public PushScope() {
        super("PushScope");
        this.autoConnectToPush = true;
    }

    public PushScope(@NotNull HashMap<String, String> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        this();
        this.properties = properties;
    }

    public PushScope(boolean autoConnect) {
        this();
        this.autoConnectToPush = autoConnect;
    }

    static {
        Companion = new Companion(null);
        SCOPE = new PushScope();
    }

    @NotNull
    public static final PushScope getSCOPE() {
        Companion companion = Companion;
        return SCOPE;
    }

    @JvmStatic
    @NotNull
    public static final SharedPreferences getPushPreferences(@NotNull Context context) {
        return Companion.getPushPreferences(context);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/flybits/android/push/PushScope$Companion;", "", "()V", "PUSH_PREF", "", "ROOT", "SCOPE", "Lcom/flybits/android/push/PushScope;", "SCOPE$annotations", "getSCOPE", "()Lcom/flybits/android/push/PushScope;", "getPushPreferences", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "push_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void SCOPE$annotations() {
        }

        @NotNull
        public final PushScope getSCOPE() {
            return SCOPE;
        }

        @JvmStatic
        @NotNull
        public final SharedPreferences getPushPreferences(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            SharedPreferences sharedPreferences = context.getSharedPreferences(PushScope.PUSH_PREF, 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026(PUSH_PREF, MODE_PRIVATE)");
            return sharedPreferences;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

