/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.models;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.push.db.PushDatabase;
import com.flybits.android.push.deserializations.DeserializePushNotification;
import com.flybits.android.push.deserializations.DeserializePushNotificationCustomFields;
import com.flybits.android.push.models.PushAction;
import com.flybits.android.push.models.PushCategory;
import com.flybits.android.push.models.PushEntity;
import com.flybits.android.push.models.results.PushResult;
import com.flybits.android.push.utils.PushQueryParameters;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="push")
public class Push
implements Parcelable {
    static final String API = "/push/notifications";
    private PushAction action;
    private HashMap<String, String> customFields;
    private String customFieldsAsString;
    private PushCategory category;
    private PushEntity entity;
    @PrimaryKey
    @NonNull
    private String id;
    private String message;
    private long timestamp;
    private String title;
    private long version;
    private String metadataID;
    public static final Parcelable.Creator<Push> CREATOR = new Parcelable.Creator<Push>(){

        public Push createFromParcel(Parcel in) {
            return new Push(in);
        }

        public Push[] newArray(int size) {
            return new Push[size];
        }
    };

    public Push() {
    }

    @Ignore
    public Push(@NonNull String id, @NonNull String entity, @NonNull String action, @NonNull String category, long version, long timestamp, String title, String alert) {
        this.id = id;
        this.entity = PushEntity.fromKey(entity);
        this.action = PushAction.fromKey(action);
        this.category = PushCategory.fromKey(category);
        this.version = version;
        this.timestamp = timestamp;
        this.title = title;
        this.message = alert;
        this.customFields = new HashMap();
    }

    @Ignore
    public Push(@NonNull String id, @NonNull String entity, @NonNull String action, @NonNull String category, long version, long timestamp, String title, String alert, String metadata, String metadataID) {
        this(id, entity, action, category, version, timestamp, title, alert);
        this.customFieldsAsString = metadata;
        this.metadataID = metadataID;
        DeserializePushNotificationCustomFields deserializer = new DeserializePushNotificationCustomFields();
        if (deserializer.fromJson(this.customFieldsAsString) != null) {
            this.customFields = (HashMap)deserializer.fromJson(this.customFieldsAsString);
        }
    }

    @Ignore
    public Push(Parcel in) {
        this.entity = PushEntity.fromKey(in.readString());
        this.action = PushAction.fromKey(in.readString());
        this.category = PushCategory.fromKey(in.readString());
        this.version = in.readLong();
        this.timestamp = in.readLong();
        this.customFieldsAsString = in.readString();
        this.message = in.readString();
        this.title = in.readString();
        this.id = in.readString();
        this.metadataID = in.readString();
        DeserializePushNotificationCustomFields deserializeResult = new DeserializePushNotificationCustomFields();
        this.customFields = (HashMap)deserializeResult.fromJson(this.customFieldsAsString);
    }

    public PushAction getAction() {
        return this.action;
    }

    public PushCategory getCategory() {
        return this.category;
    }

    public String getCustomFieldsAsString() {
        return this.customFieldsAsString;
    }

    public HashMap<String, String> getCustomFields() {
        return this.customFields;
    }

    public PushEntity getEntity() {
        return this.entity;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMetadataID() {
        return this.metadataID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTitle() {
        return this.title;
    }

    public long getVersion() {
        return this.version;
    }

    public void setAction(PushAction action) {
        this.action = action;
    }

    public void setCustomFieldsAsString(String customFieldsAsString) {
        this.customFieldsAsString = customFieldsAsString;
    }

    public void setCategory(PushCategory category) {
        this.category = category;
    }

    public void setCustomFields(HashMap<String, String> customFields) {
        this.customFields = customFields;
    }

    public void setEntity(PushEntity entity) {
        this.entity = entity;
    }

    public void setId(@NonNull String id) {
        this.id = id;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMetadataID(String metadataID) {
        this.metadataID = metadataID;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String toString() {
        return "{ \"id\" : " + this.id + ", \"version\" : " + this.version + ", \"timestamp\" : " + this.timestamp + ", \"entity\" : \"" + this.entity.getKey() + "\", \"action\" : \"" + this.action.getKey() + "\", \"category\" : \"" + this.category.getKey() + "\", \"title\" : \"" + this.title + "\", \"alert\" : \"" + this.message + "\", \"body\" : " + this.customFieldsAsString + ", \"metadataID\" : " + this.metadataID + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.entity.getKey());
        out.writeString(this.action.getKey());
        out.writeString(this.category.getKey());
        out.writeLong(this.version);
        out.writeLong(this.timestamp);
        out.writeString(this.customFieldsAsString);
        out.writeString(this.message);
        out.writeString(this.title);
        out.writeString(this.id);
        out.writeString(this.metadataID);
    }

    public static PushResult get(final @NonNull Context context, final @NonNull PushQueryParameters params, PagedResultCallback<Push> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final PushResult query = new PushResult(context, callback, executorService, params, handler);
        query.setService(executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializePushNotification singleDersializer = new DeserializePushNotification();
                    Result result = FlyAway.get((Context)context, (String)Push.API, (QueryParameters)params, (IDeserializer)new DeserializePagedResponse((IDeserializer)singleDersializer), (String)"Push.get");
                    if (result.getStatus() == RequestStatus.COMPLETED) {
                        int maxNumberOfRecordsToSave;
                        if ((params.getQueryParams().get("offset") == null || params.getQueryParams().get("offset").size() == 0 || params.getQueryParams().get("offset").get(0).equals("0")) && params.getCachingKey() != null) {
                            PushDatabase.getDatabase(context).pushDao().clear();
                            CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().deleteAllByCachingKey(params.getCachingKey());
                        }
                        int n = maxNumberOfRecordsToSave = (long)params.getCachingLimit() < (long)((PagedResponse)result.getResult()).getItems().size() + ((PagedResponse)result.getResult()).getPagination().getOffset() ? params.getCachingLimit() : ((PagedResponse)result.getResult()).getItems().size();
                        if (params.getCachingKey() != null && maxNumberOfRecordsToSave > 0) {
                            ArrayList<CachingEntry> entries = new ArrayList<CachingEntry>();
                            ArrayList<Push> pushesToCache = new ArrayList<Push>();
                            for (int i = 0; i < ((PagedResponse)result.getResult()).getItems().size() && i < maxNumberOfRecordsToSave; ++i) {
                                pushesToCache.add((Push)((PagedResponse)result.getResult()).getItems().get(i));
                                entries.add(new CachingEntry("com.flybits.caching.push.NOTIFICATIONS", ((Push)((PagedResponse)result.getResult()).getItems().get(i)).getId()));
                            }
                            PushDatabase.getDatabase(context).pushDao().insert(pushesToCache);
                            CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().insert(entries);
                        }
                    }
                    query.setResult(result, params);
                }
                catch (FlybitsException e) {
                    query.setFailed(e);
                }
            }
        });
        return query;
    }

    public static PushResult get(@NonNull Context mContext, @NonNull PushQueryParameters params) {
        return Push.get(mContext, params, null);
    }

    public BasicResult delete(final @NonNull Context mContext, @NonNull BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult resultObject = new BasicResult(mContext, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result result = FlyAway.delete((Context)mContext, (String)Push.API, (String)"Push.delete", (String)Push.this.id);
                    if (result.getStatus() == RequestStatus.COMPLETED) {
                        PushDatabase.getDatabase(mContext).pushDao().delete(Push.this);
                    }
                    resultObject.setResult(result);
                }
                catch (FlybitsException e) {
                    resultObject.setFailed(e);
                }
            }
        });
        return resultObject;
    }
}

