package com.flybits.android.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;

import com.flybits.android.push.db.PushDatabase;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.User;

import java.util.HashMap;

import static android.content.Context.MODE_PRIVATE;

public class PushScope extends FlybitsScope{

    public static final String ROOT = "/push";
    public static PushScope SCOPE = new PushScope();
    private HashMap<String, String> properties;

    /**
     * This constructor should be used in the event that the application subscribed to Firebase
     * specific push notifications.
     */
    PushScope() {
        super("PushScope");
    }

    public PushScope(HashMap<String, String> properties){
        this();
        this.properties = properties;
    }

    @Override
    public void onConnected(Context context, User user) {
        PushManager.enablePush(context, properties, null);
    }

    @Override
    public void onDisconnected(final Context context, String jwtToken) {

        PushManager.disablePush(context, jwtToken, new BasicResultCallback() {
            @Override
            public void onSuccess() {
                clearPushPreferences(context);
            }

            @Override
            public void onException(FlybitsException exception) {

            }
        });
    }

    @Override
    public void onAccountDestroyed(Context context, String jwtToken) {
        onDisconnected(context, jwtToken);
    }

    /**
     * Get the default shared preferences for the application.
     *
     * @param context The context of the application.
     * @return The default SharedPreferences object for the application.
     */
    public static SharedPreferences getPushPreferences(Context context){
        return context.getSharedPreferences("FLYBITS_PREF_PUSH", MODE_PRIVATE );
    }

    private void clearPushPreferences(final Context context){
        SharedPreferences.Editor preferences   = getPushPreferences(context).edit();
        preferences.clear();
        preferences.apply();
        new ClearDatabase(context).execute();
    }

    private class ClearDatabase extends AsyncTask<Void, Void, Void> {

        private Context context;

        public ClearDatabase(Context context){
            this.context    = context;
        }

        protected Void doInBackground(Void... urls) {
            PushDatabase.getDatabase(context).pushDao().clear();
            return null;
        }
    }
}
