/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.android.push.api.FlyPushParsing;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushManager {
    public static BasicResult disablePush(Context context, BasicResultCallback callback) {
        return PushManager.disablePush(context, SharedElements.getSavedJWTToken((Context)context), callback);
    }

    public static void enablePush(final Context context, final @Nullable HashMap<String, String> properties, final BasicResultCallback callback) {
        FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

            public void onSuccess(InstanceIdResult instanceIdResult) {
                final String newToken = instanceIdResult.getToken();
                Handler handler = new Handler(Looper.getMainLooper());
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                final BasicResult resultObject = new BasicResult(context, callback, executorService, handler);
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PushToken resultSerializationObj = new PushToken(newToken, properties);
                            DeserializePushToken deserialization = new DeserializePushToken();
                            String json = deserialization.toJson(resultSerializationObj);
                            Result pushResult = FlyAway.post((Context)context, (String)"/push/token", (String)json, null, (String)"PushManager.enablePush", null);
                            resultObject.setResult(pushResult);
                        }
                        catch (FlybitsException e) {
                            resultObject.setFailed(e);
                        }
                    }
                });
            }
        });
    }

    public static <T extends IDeserializer> void parsePushNotification(@NonNull Context mContext, @NonNull Map map, ObjectResultCallback<Push> callback) {
        block3: {
            try {
                Push push = FlyPushParsing.parsePushNotification(mContext, map);
                if (callback != null) {
                    callback.onSuccess((Object)push);
                }
            }
            catch (FlybitsPushException e) {
                if (callback == null) break block3;
                callback.onException((FlybitsException)e);
            }
        }
    }

    static BasicResult disablePush(final Context context, final @NonNull String jwttoken, BasicResultCallback callback) {
        if (jwttoken == null) {
            BasicResult result = new BasicResult(context, callback);
            callback.onException(new FlybitsException("Your JWT Token appears to be null. Please make sure you have set to disable push."));
            return result;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult resultObject = new BasicResult(context, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap<String, String> mapOfHeaders = new HashMap<String, String>();
                    mapOfHeaders.put("X-Authorization", jwttoken);
                    Result result = FlyAway.delete((Context)context, (String)"/push/token", mapOfHeaders, (String)"PushManager.disablePush", null);
                    resultObject.setResult(result);
                }
                catch (FlybitsException e) {
                    Logger.exception((String)"PushManager.disablePush", (Exception)((Object)e));
                    resultObject.setFailed(e);
                }
            }
        });
        return resultObject;
    }
}

