package com.flybits.android.push.utils;

import android.support.annotation.NonNull;

import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;

import java.util.ArrayList;
import java.util.Map;

/**
 * The {@link PushTemplateQueryParameters} class is used to define all the parameters set for the
 * GET request associated to {@link com.flybits.android.push.models.PushTemplate}.
 */
public class PushTemplateQueryParameters extends QueryParameters {

    private SortOrder order;

    private PushTemplateQueryParameters(Builder builder) {
        super(builder);
        order           = builder.sort;
    }

    /**
     * Get the list of query parameters that should be added to the GET request.
     *
     * @return A list of parameters that should be added to the GET query.
     */
    public Map<String, ArrayList<String>> getQueryParams(){

        Map<String, ArrayList<String>> params = super.getQueryParams();
        ArrayList<String> listOfSorts = new ArrayList<>();
        listOfSorts.add(order.getKey());
        params.put("order", listOfSorts);
        return params;
    }

    /**
     * The {@code Builder} class that defines all the possible filter options that can be used when
     * retrieving a list of Push Notifications.
     */
    public static class Builder extends QueryBuilder<Builder> {

        SortOrder sort;

        /**
         * Default Constructor that defines an empty {@code Builder}.
         */
        public Builder(){
            super();
            sort            = SortOrder.DESCENDING;
        }

        /**
         * Build the {@code PushHistoryOptions} object to be used for constructing an HTTP request.
         *
         * @return {@code PushHistoryOptions} object which can be referenced by the SDK to get
         * specific information about a list of Push Notifications.
         */
        public PushTemplateQueryParameters build(){
            return new PushTemplateQueryParameters(this);
        }

        /**
         * Sets the sort order by created time of the response from the Server.
         *
         * @return A {@code Builder} object where additional filter settings can be set.
         */
        public Builder setSortOrder(@NonNull SortOrder order){
            if (order == null){
                return this;
            }

            this.sort   = order;
            return this;
        }
    }
}
