/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.utils;

import android.support.annotation.NonNull;
import com.flybits.android.push.utils.SortOrder;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class PushQueryParameters
extends QueryParameters {
    private long epochStartTime;
    private long epochEndTime;
    private SortOrder order;

    private PushQueryParameters(Builder builder) {
        this.epochStartTime = builder.epochStartTime;
        this.epochEndTime = builder.epochEndTime;
        this.order = builder.sort;
        this.addPaging(builder.limit, builder.offset);
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.epochEndTime > -1L && this.epochStartTime > -1L) {
            ArrayList<String> listOfStartTime = new ArrayList<String>();
            listOfStartTime.add(String.valueOf(this.epochStartTime));
            params.put("from", listOfStartTime);
            ArrayList<String> listOfEndTime = new ArrayList<String>();
            listOfEndTime.add(String.valueOf(this.epochEndTime));
            params.put("to", listOfEndTime);
        }
        ArrayList<String> listOfSorts = new ArrayList<String>();
        listOfSorts.add(this.order.getKey());
        params.put("order", listOfSorts);
        return params;
    }

    public static class Builder {
        long limit = 10L;
        long offset = 0L;
        long epochStartTime = -1L;
        long epochEndTime = -1L;
        SortOrder sort = SortOrder.DESCENDING;

        public Builder addPaging(long limit, long offset) {
            this.limit = limit;
            this.offset = offset;
            return this;
        }

        public Builder addTimeRange(long epochStartTime, long epochEndTime) {
            this.epochStartTime = epochStartTime;
            this.epochEndTime = epochEndTime;
            return this;
        }

        public PushQueryParameters build() {
            return new PushQueryParameters(this);
        }

        public Builder setSortOrder(@NonNull SortOrder order) {
            if (order == null) {
                return this;
            }
            this.sort = order;
            return this;
        }
    }
}

