/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.utils;

import android.support.annotation.NonNull;
import com.flybits.android.push.utils.SortOrder;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class PushTemplateQueryParameters
extends QueryParameters {
    private SortOrder order;

    private PushTemplateQueryParameters(Builder builder) {
        this.order = builder.sort;
        this.addPaging(builder.limit, builder.offset);
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        ArrayList<String> listOfSorts = new ArrayList<String>();
        listOfSorts.add(this.order.getKey());
        params.put("order", listOfSorts);
        return params;
    }

    public static class Builder {
        long limit = 10L;
        long offset = 0L;
        SortOrder sort = SortOrder.DESCENDING;

        public Builder addPaging(long limit, long offset) {
            this.limit = limit;
            this.offset = offset;
            return this;
        }

        public PushTemplateQueryParameters build() {
            return new PushTemplateQueryParameters(this);
        }

        public Builder setSortOrder(@NonNull SortOrder order) {
            if (order == null) {
                return this;
            }
            this.sort = order;
            return this;
        }
    }
}

