/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.api;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.android.push.deserializations.DeserializePushPreferences;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushPreferenceManager {
    static final String API = "/push/preferences";

    public static BasicResult clear(final @NonNull Context mContext, @NonNull BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result result = FlyAway.delete((Context)mContext, (String)PushPreferenceManager.API, (String)"PushPreferenceManager.clear", null);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setResult(result);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setFailed(e);
                        }
                    });
                }
            }
        });
        return query;
    }

    public static ObjectResult<String[]> get(final @NonNull Context mContext, @NonNull ObjectResultCallback<String[]> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult query = new ObjectResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result result = FlyAway.get((Context)mContext, (String)PushPreferenceManager.API, (IDeserializer)new DeserializePushPreferences(), (String)"PushPreferenceManager.get", String[].class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setResult(result);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setFailed(e);
                        }
                    });
                }
            }
        });
        return query;
    }

    public static BasicResult post(final @NonNull Context mContext, final @NonNull ArrayList<String> keywords, final BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] listOfTopics = keywords.toArray(new String[keywords.size()]);
                    String json = new DeserializePushPreferences().toJson(listOfTopics);
                    final Result result = FlyAway.post((Context)mContext, (String)PushPreferenceManager.API, (String)json, (IDeserializer)new DeserializePushPreferences(), (String)"PushPreferenceManager.post", String[].class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setResult(result);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(e);
                        }
                    });
                }
            }
        });
        return query;
    }
}

