/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.android.push.PushScope;
import com.flybits.android.push.api.FlyPushParsing;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushManager {
    static final String PREF_FIREBASE_TOKEN = "FIREBASE_TOKEN";
    static final String PREF_PUSH_GCM_APP_ID = "prefApplicationID";
    static final String PREF_PUSH_GCM_TOKEN = "prefGCMRegistrationID";
    static final String PREF_PUSH_APP_VERSION = "prefAppVersion";

    public static BasicResult disablePush(final Context mContext, final String jwttoken, BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult resultObject = new BasicResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap<String, String> mapOfHeaders = new HashMap<String, String>();
                    mapOfHeaders.put("X-Authorization", jwttoken);
                    final Result result = FlyAway.delete((Context)mContext, (String)"/push/token", mapOfHeaders, (String)"PushManager.disablePush", null);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            resultObject.setResult(result);
                        }
                    });
                }
                catch (FlybitsException e) {
                    Logger.exception((String)"PushManager.disablePush", (Exception)((Object)e));
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            resultObject.setFailed(e);
                        }
                    });
                }
            }
        });
        return resultObject;
    }

    public static BasicResult enableGCMPush(final Context mContext, String appID, BasicResultCallback callback) {
        final SharedPreferences.Editor sharedPreferencesEditor = PushScope.getPushPreferences(mContext).edit();
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)mContext);
            if (instanceID == null) {
                return PushManager.returnError(mContext, callback);
            }
            final String token = instanceID.getToken(appID, "GCM", null);
            if (token == null) {
                return PushManager.returnError(mContext, callback);
            }
            Logger.setTag((String)"PushManager").i("GCM Registration Token: " + token);
            final Handler handler = new Handler(Looper.getMainLooper());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            final BasicResult resultObject = new BasicResult(mContext, callback, executorService);
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PushToken resultSerializationObj = new PushToken(token, null);
                        DeserializePushToken deserialization = new DeserializePushToken();
                        String json = deserialization.toJson(resultSerializationObj);
                        final Result pushResult = FlyAway.post((Context)mContext, (String)"/push/token", (String)json, null, (String)"PushManager.enableFCM", null);
                        sharedPreferencesEditor.putBoolean("SENT_TOKEN_TO_SERVER", pushResult.getStatus() == RequestStatus.COMPLETED).apply();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                resultObject.setResult(pushResult);
                            }
                        });
                    }
                    catch (FlybitsException e) {
                        Logger.exception((String)"PushManager.enableGCMPush", (Exception)((Object)e));
                        sharedPreferencesEditor.putBoolean("SENT_TOKEN_TO_SERVER", false).apply();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                resultObject.setFailed(e);
                            }
                        });
                    }
                }
            });
            return resultObject;
        }
        catch (IOException | NullPointerException e) {
            return PushManager.returnError(mContext, callback);
        }
    }

    public static BasicResult enableFCMPush(final Context mContext, BasicResultCallback callback) {
        final String firebaseToken = PushManager.getSavedFirebaseToken(mContext);
        if (firebaseToken != null && firebaseToken.length() > 0) {
            final Handler handler = new Handler(Looper.getMainLooper());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            final BasicResult resultObject = new BasicResult(mContext, callback, executorService);
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PushToken resultSerializationObj = new PushToken(firebaseToken, null);
                        DeserializePushToken deserialization = new DeserializePushToken();
                        String json = deserialization.toJson(resultSerializationObj);
                        final Result pushResult = FlyAway.post((Context)mContext, (String)"/push/token", (String)json, null, (String)"PushManager.enableFCM", null);
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                resultObject.setResult(pushResult);
                            }
                        });
                    }
                    catch (FlybitsException e) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                resultObject.setFailed(e);
                            }
                        });
                    }
                }
            });
            return resultObject;
        }
        return PushManager.returnError(mContext, callback);
    }

    public static String getAppID(Context context) {
        SharedPreferences prefs = PushScope.getPushPreferences(context);
        return prefs.getString(PREF_PUSH_GCM_APP_ID, "");
    }

    public static int getAppVersion(Context context) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        return packageInfo.versionCode;
    }

    public static String getRegistrationId(Context context) {
        SharedPreferences prefs = PushScope.getPushPreferences(context);
        String registrationId = prefs.getString(PREF_PUSH_GCM_TOKEN, "");
        if (registrationId.isEmpty()) {
            return "";
        }
        int registeredVersion = prefs.getInt(PREF_PUSH_APP_VERSION, Integer.MIN_VALUE);
        try {
            int currentVersion = PushManager.getAppVersion(context);
            if (registeredVersion != currentVersion) {
                return "";
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
        return registrationId;
    }

    public static String getStoredGCMToken(Context mContext) {
        SharedPreferences prefs = PushScope.getPushPreferences(mContext);
        return prefs.getString(PREF_PUSH_GCM_TOKEN, "");
    }

    public static void parsePushNotification(@NonNull Context mContext, @NonNull Bundle bundle, ObjectResultCallback<Push> callback) {
        block3: {
            try {
                Push push = FlyPushParsing.parsePushNotification(mContext, bundle);
                if (callback != null) {
                    callback.onSuccess((Object)push);
                }
            }
            catch (FlybitsPushException e) {
                if (callback == null) break block3;
                callback.onException((FlybitsException)e);
            }
        }
    }

    public static <T extends IDeserializer> void parsePushNotification(@NonNull Context mContext, @NonNull Map map, ObjectResultCallback<Push> callback) {
        block3: {
            try {
                Push push = FlyPushParsing.parsePushNotification(mContext, map);
                if (callback != null) {
                    callback.onSuccess((Object)push);
                }
            }
            catch (FlybitsPushException e) {
                if (callback == null) break block3;
                callback.onException((FlybitsException)e);
            }
        }
    }

    public static void setAppGCMID(Context mContext, String appID) {
        SharedPreferences.Editor prefs = PushScope.getPushPreferences(mContext).edit();
        prefs.putString(PREF_PUSH_GCM_APP_ID, appID);
        prefs.apply();
    }

    public static void setGCMToken(Context context, String regId) {
        SharedPreferences.Editor prefs = PushScope.getPushPreferences(context).edit();
        try {
            int appVersion = PushManager.getAppVersion(context);
            prefs.putString(PREF_PUSH_GCM_TOKEN, regId);
            prefs.putInt(PREF_PUSH_APP_VERSION, appVersion);
            prefs.apply();
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.exception((String)"PushManager.setGCMToken", (Exception)((Object)e));
        }
    }

    public static String getSavedFirebaseToken(Context mContext) {
        SharedPreferences preferences = PushScope.getPushPreferences(mContext);
        return preferences.getString(PREF_FIREBASE_TOKEN, "");
    }

    public static void setFirebaseToken(Context mContext, @NonNull String firebaseToken) {
        SharedPreferences.Editor prefs = PushScope.getPushPreferences(mContext).edit();
        prefs.putString(PREF_FIREBASE_TOKEN, firebaseToken);
        prefs.apply();
    }

    @Nullable
    static String getPushToken(Context mContext) {
        SharedPreferences preferences = PushScope.getPushPreferences(mContext);
        if (!PushManager.getSavedFirebaseToken(mContext).equals("")) {
            return preferences.getString(PREF_FIREBASE_TOKEN, "");
        }
        if (!PushManager.getRegistrationId(mContext).equals("")) {
            return PushManager.getRegistrationId(mContext);
        }
        return null;
    }

    private static BasicResult returnError(Context mContext, BasicResultCallback callback) {
        BasicResult result = new BasicResult(mContext, callback);
        result.setFailed(new FlybitsException("Could not obtain InstanceID."));
        return result;
    }
}

