/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.services.fcm;

import android.content.Context;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

public class FlybitsFirebaseInstanceIDService
extends FirebaseInstanceIdService {
    private static final String _TAG = "FlybitsFirebaseInstanceIDService";

    public void onTokenRefresh() {
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        Logger.setTag((String)_TAG).i("Refreshed token: " + refreshedToken);
        this.saveFirebaseToken(this.getBaseContext(), refreshedToken);
        if (SharedElements.getSavedJWTToken((Context)this.getBaseContext()) != null && SharedElements.getSavedJWTToken((Context)this.getBaseContext()).length() > 0) {
            this.sendRegistrationToServer(this.getBaseContext(), refreshedToken);
        }
    }

    private void saveFirebaseToken(Context context, String refreshedToken) {
        PushManager.setFirebaseToken(context, refreshedToken);
    }

    private Result sendRegistrationToServer(Context context, String token) {
        try {
            PushToken resultSerializationObj = new PushToken(token, null);
            DeserializePushToken deserialization = new DeserializePushToken();
            String json = deserialization.toJson(resultSerializationObj);
            return FlyAway.post((Context)context, (String)"/push/token", (String)json, null, (String)"PushManager.enableFCM", null);
        }
        catch (FlybitsException e) {
            return null;
        }
    }
}

