/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.services;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.R;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;

public class FlybitsPushService
extends FirebaseMessagingService {
    private final String _TAG = "FlybitsFirebaseReceiver";
    private final String NOTIFICATION_CHANNEL_FLYBITS = "com.flybits.push.channel.generic";

    public void onMessageReceived(final RemoteMessage message) {
        Logger.setTag((String)"FlybitsFirebaseReceiver").i("FlybitsFCMReceiver->Received Message: " + message.getData());
        Map data = message.getData();
        PushManager.parsePushNotification(this.getBaseContext(), data, new ObjectResultCallback<Push>(){

            public void onSuccess(Push push) {
                Logger.setTag((String)"FlybitsFirebaseReceiver").i("Received Flybits Push: " + push.toString());
                FlybitsPushService.this.setNotification(FlybitsPushService.this.getBaseContext(), push.getTitle(), push.getMessage());
                Intent intentCustom = new Intent("com.flybits.action.push.received.flybits");
                intentCustom.putExtra("com.flybits.action.push.received.flybits", (Parcelable)push);
                LocalBroadcastManager.getInstance((Context)FlybitsPushService.this.getBaseContext()).sendBroadcast(intentCustom);
            }

            public void onException(FlybitsException e) {
                if (e instanceof FlybitsPushException) {
                    if (message.getNotification() != null) {
                        Logger.setTag((String)"FlybitsFirebaseReceiver").i("Received FCM Push: " + message.getNotification().getBody());
                        FlybitsPushService.this.setNotification(FlybitsPushService.this.getBaseContext(), message.getNotification().getTitle(), message.getNotification().getBody());
                    }
                    Intent intentCustom = new Intent("com.flybits.action.push.received.fcm");
                    intentCustom.putExtra("com.flybits.extra.push", (Parcelable)message);
                    LocalBroadcastManager.getInstance((Context)FlybitsPushService.this.getBaseContext()).sendBroadcast(intentCustom);
                }
            }
        });
    }

    private void setNotification(Context context, String title, String body) {
        boolean isTitlePresent;
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        boolean bl = isTitlePresent = !TextUtils.isEmpty((CharSequence)title);
        if (body == null) {
            body = "";
        }
        long[] vibration = new long[]{100L};
        NotificationCompat.BigTextStyle bigText = new NotificationCompat.BigTextStyle();
        bigText.bigText((CharSequence)body);
        String txtTitle = isTitlePresent ? title : "Received Notification";
        bigText.setBigContentTitle((CharSequence)txtTitle);
        int resourceIcon = this.getResource();
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, "com.flybits.push.channel.generic").setContentText((CharSequence)body).setSmallIcon(resourceIcon).setBadgeIconType(1).setVibrate(vibration).setStyle((NotificationCompat.Style)bigText).setWhen(System.currentTimeMillis()).setShowWhen(true).setAutoCancel(true);
        if (isTitlePresent) {
            mBuilder.setContentTitle((CharSequence)txtTitle);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String channelName = this.getChannelName();
            NotificationChannel mChannel = new NotificationChannel("com.flybits.push.channel.generic", (CharSequence)channelName, 3);
            mChannel.enableLights(true);
            mChannel.enableVibration(true);
            mNotificationManager.createNotificationChannel(mChannel);
        }
        int num = (int)System.currentTimeMillis();
        mNotificationManager.notify(num, mBuilder.build());
    }

    private int getResource() {
        try {
            ComponentName myService = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
            Bundle bundle = this.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
            if (bundle.containsKey("com.flybits.push.notification.icon")) {
                return bundle.getInt("com.flybits.push.notification.icon");
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.exception((String)"FlybitsPushService.getResource", (Exception)e);
        }
        Logger.setTag((String)"FlybitsFirebaseReceiver").w("It appears that you have not set your icon's resource field within your AndroidManifest declaration of the FlybitsPushService. Please visit https://devportal.flybits.com/#/documentation/android/push/push-notifications-receiving for more details.");
        return R.mipmap.ic_flybits_notification;
    }

    private String getChannelName() {
        try {
            ComponentName myService = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
            Bundle bundle = this.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
            if (bundle.containsKey("com.flybits.push.notification.title")) {
                return bundle.getString("com.flybits.push.notification.title");
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.exception((String)"FlybitsPushService.getChannelName", (Exception)e);
        }
        Logger.setTag((String)"FlybitsFirebaseReceiver").w("It appears that you have not set your title field within your AndroidManifest declaration of the FlybitsPushService. Please visit https://devportal.flybits.com/#/documentation/android/push/push-notifications-receiving for more details.");
        return "Notifications";
    }
}

