/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.models.PushType;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.Result;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushToken
implements Parcelable {
    public static final String API = "/push/token";
    private HashMap<String, String> data;
    private String deviceToken;
    private PushType network;
    public static final Parcelable.Creator<PushToken> CREATOR = new Parcelable.Creator<PushToken>(){

        public PushToken createFromParcel(Parcel in) {
            return new PushToken(in);
        }

        public PushToken[] newArray(int size) {
            return new PushToken[size];
        }
    };

    public PushToken(@NonNull String token) {
        this.deviceToken = token;
        this.network = PushType.GCM;
    }

    public HashMap<String, String> getData() {
        return this.data;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public PushType getType() {
        return this.network;
    }

    public PushToken(String token, HashMap<String, String> data) {
        this.deviceToken = token;
        this.network = PushType.GCM;
        this.data = data;
    }

    protected PushToken(Parcel in) {
        this.deviceToken = in.readString();
        this.network = PushType.fromKey(in.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.deviceToken);
        out.writeInt(this.network.getKey());
    }

    public static ObjectResult<PushToken> get(final @NonNull Context mContext, ObjectResultCallback<PushToken> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult query = new ObjectResult(mContext, callback, executorService);
        query.setService(executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result result = FlyAway.get((Context)mContext, (String)PushToken.API, (IDeserializer)new DeserializePushToken(), (String)"PushToken.get", PushToken.class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setResult(result);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            query.setFailed(e);
                        }
                    });
                }
            }
        });
        return query;
    }
}

