/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.db.PushDatabase;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.User;

public class PushScope
extends FlybitsScope {
    public static final String ROOT = "/push";
    public static PushScope SCOPE = new PushScope();
    private String gcmSenderID;
    private PushType type;

    public PushScope() {
        super("PushScope");
        this.type = PushType.FCM;
    }

    public PushScope(String gcmSenderID) {
        super("PushScope");
        this.type = PushType.GCM;
        this.gcmSenderID = gcmSenderID;
    }

    public void onConnected(Context context, User user) {
        switch (this.type) {
            case GCM: {
                PushManager.enableGCMPush(context, this.gcmSenderID, new BasicResultCallback(){

                    public void onSuccess() {
                    }

                    public void onException(FlybitsException exception) {
                    }
                });
                break;
            }
            case FCM: {
                PushManager.enableFCMPush(context, new BasicResultCallback(){

                    public void onSuccess() {
                    }

                    public void onException(FlybitsException exception) {
                    }
                });
            }
        }
    }

    public void onDisconnected(final Context context, String jwtToken) {
        PushManager.disablePush(context, jwtToken, new BasicResultCallback(){

            public void onSuccess() {
                PushScope.this.clearPushPreferences(context);
            }

            public void onException(FlybitsException exception) {
            }
        });
    }

    public void onAccountDestroyed(Context context, String jwtToken) {
        this.onDisconnected(context, jwtToken);
    }

    public static SharedPreferences getPushPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF_PUSH", 0);
    }

    private void clearPushPreferences(Context context) {
        SharedPreferences.Editor preferences = PushScope.getPushPreferences(context).edit();
        preferences.clear();
        preferences.apply();
        new ClearDatabase(context).execute(new Void[0]);
    }

    private class ClearDatabase
    extends AsyncTask<Void, Void, Void> {
        private Context context;

        public ClearDatabase(Context context) {
            this.context = context;
        }

        protected Void doInBackground(Void ... urls) {
            PushDatabase.getDatabase(this.context).pushDao().clear();
            return null;
        }
    }

    private static enum PushType {
        FCM,
        GCM;

    }
}

