package com.flybits.android.push.services.gcm;

import android.os.Bundle;

import com.flybits.android.push.api.FlyPushParsing;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.commons.library.logging.Logger;
import com.google.android.gms.gcm.GcmListenerService;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FlybitsGCMListenerService extends GcmListenerService {

    private static final String TAG = "MyGcmListenerService";

    /**
     * Called when message is received.
     *
     * @param from SenderID of the sender.
     * @param data Data bundle containing message data as key/value pairs.
     *             For Set of keys use data.keySet().
     */
    // [START receive_message]
    @Override
    public void onMessageReceived(String from, final Bundle data) {

        Logger.setTag(TAG).i("onMessageReceived:" + from);
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable() {
            public void run() {
                try {
                    FlyPushParsing.parsePushNotification(getApplicationContext(), data);
                }catch(final FlybitsPushException e){
                    Logger.exception("FlybitsGCMListenerService.onMessageReceived", e);
                }
            }
        });
    }

}